package fr.cnam.othello.vue;

import java.util.*;

import fr.cnam.othello.model.ModelOthello;

// Classe de definition de l'observer de l'ihm d'Othello
//
public class ObserverOthello implements Observer
{
  VueAfficherOthello vue;
    
  // Constructeur
  //
  public ObserverOthello(VueAfficherOthello vue)
  {
    this.vue=vue;
  }

  // Methode de notification : arg est toutes les donnees du modele
  //
  public void update(Observable o,Object arg)
  {
    if (arg!=null)
      {
        System.out.println("ObserverOthello : update");
        DataVueOthello data = (DataVueOthello)arg;
        for(int i=0;i<ModelOthello.NB_COLONNES;i++)
          for(int j=0;j<ModelOthello.NB_LIGNES;j++)
            {
              vue.getIHM().setMarque(data.getGrille()[i][j],i,j);
            }
      }
  }
}