package fr.cnam.othello.vue;

import java.util.*;

import fr.cnam.othello.model.ModelOthello;
import fr.cnam.othello.controleur.*;

// Classe de definition de l'observer de l'ihm d'Othello
//
public class ObserverOthelloRobot implements Observer
{
  VueAfficherOthello vue;
    
  // Constructeur
  //
  public ObserverOthelloRobot(VueAfficherOthello vue)
  {
    this.vue=vue;
  }

  // Methode de notification : arg est toutes les donnees du modele
  //
  public void update(Observable o,Object arg)
  {
    System.out.println(">>ObserverOthelloRobot: update");
    Robot.getInstance();
  }
}

class Robot implements Runnable
{
  private static Robot singleton=null;
  private Robot()
  {
    new Thread(this).start();
  }
  public static Robot getInstance(){
    if(singleton==null)return new Robot();
    else return singleton;
  }
  public void run(){
    while(true){
      try{
        for(int i=0;i<ModelOthello.NB_COLONNES;i++)
          for(int j=0;j<ModelOthello.NB_LIGNES;j++)
            ControleurOthelloImpl.getInstance().actionJouerOthello(2,i,j);
        Thread.sleep(200);
      }catch(Exception ex){};
    }
  }
}