package fr.cnam.othello.vue;

import java.util.*;

import fr.cnam.othello.model.ModelOthello;

// Classe de definition du proxy de l'observer de la vue qui permet
//  de faire une notification vers la vue qui est distante
//
public class ProxyObserverOthello implements Observer
{
  private ObserverDistant observerDistant;
  
  // Constructeur
  public ProxyObserverOthello(ObserverDistant observerDistant)
  {
    this.observerDistant=observerDistant;
  }
  
  // Methode de notification qui appelle la mthode update du stub
  //
  public void update(Observable o,Object arg)
  {
    try{
      DataVueOthello  data  = (DataVueOthello)arg;
      observerDistant.update(o,data);
    }catch(Exception ex){System.out.println(">>ProxyObserverOthello>update: Erreur sur le stub");
      ex.printStackTrace();};
  }
}