package fr.cnam.othello.vue;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import fr.cnam.othello.model.*;
import fr.cnam.othello.controleur.*;
import fr.cnam.ihm.*;

// Classe de definition d'une vue qui affiche un jeu d'othello
//
public class VueAfficherOthello implements FormulaireInt, ControlesCanvasIHM
{
  private   ControleurOthello controleur; // Le controleur
  private   CanvasIHM         ihm;        // L'IHM de la grille
  private   int               numJoueur;  // 1 ou 2
  private   Formulaire        form;       // Le formulaire
  private   boolean           modeRobot;  // En mode robot


  // Constructeur de la vue
  //
  public VueAfficherOthello(int numJoueurArg)
  {
    // Initialisation par defaut des attributs de la vue
    //
    numJoueur  = numJoueurArg;
    controleur = ControleurOthelloImpl.getInstance();
    modeRobot = false;

    // Creation du formulaire
    //
    CanvasIHM.TYPE_MARQUE=2; // Afficher des ronds plutoit que des carres
    form = new Formulaire("OTHELLO",this,300,300);
    form.addButton("ROB","MODE ROBOT");
    ihm = form.addGrilleIHM(ModelOthello.NB_COLONNES,ModelOthello.NB_LIGNES,20,this);

    // Abonnement au modele
    //
    controleur.addObserveur(new ObserverOthello(this));

  }

  // getteur
  //
  public CanvasIHM getIHM(){return ihm;}

  // Affichage de l'ihm
  // 
  public void afficher()
  {
    // Affichage de l'IHM
    form.afficher(10+500*(numJoueur-1),10);

    // Demande au controleur de recuperer toutes les informations du modele via
    //  la notification. 
    //
    controleur.actionNotificationOthello();
  }

  // Methode appele quand on clique sur un bouton
  //
  public void     submit(Formulaire form,String nom)
  {
    if (nom.equals("ROB"))
      {
        if (! modeRobot)
          {
            modeRobot=true;
            new RobotOthello(numJoueur);
            controleur.actionNotificationOthello();
          }
        else
          {
            System.out.println("MODE ROBOt DEJA ACTIF");
          }
      }
  }

  // Methode appele quand on clique dans une case
  //
  public void pointerCaseGrille(int xCase,int yCase,CanvasIHM ihm)
  {
    System.out.println("pointerCaseGrille: "+xCase+" "+yCase);
    boolean aujoueurdejouer = controleur.actionJouerOthello(numJoueur,xCase,yCase);
    if (!aujoueurdejouer)
      System.out.println("COUP INVALIDE OU CE N'EST PAS A VOUS DE JOUER");
  }
  
  // Non utilise
  public void pointerCanvas(Object target,int x,int y,CanvasIHM ihm)
  {
  }

    
}

