package fr.cnam.prog;

import java.util.*;
import java.rmi.registry.*;

import fr.cnam.ihm.*;

import fr.cnam.othello.vue.*;
import fr.cnam.othello.controleur.*;

// Programme principal d'execution du jeu d'othello
//
// Ce programme est utilise par chacun des joueur en passant en parametre
//  le numero du joueur
//
// Le joueur 1 doit lancer en premier son programme (il est le maitre)
//  et ensuite le joueur 2
//
//   args[0] = numero du joueur : 1 ou 2
//
public class Exercice06_Joueur
{
  static public String addresseHostJoueur1 = "localhost";

  public static void main(String... args) throws Exception
  {
    int numJoueur = Integer.parseInt(args[0]);  // 1 ou 2

    // Si c'est le joueur 2 alors il est l'esclave. Le controleur qu'il utilise
    //  est donc remote (il se trouve dans la JVM du joueur 1)
    //
    if (numJoueur == 2) ControleurOthelloImpl.remote();
        

    // Creation de l'IHM du joueur
    VueAfficherOthello vueJeu = new VueAfficherOthello(numJoueur);
    vueJeu.afficher();

  }
}
