/*
 * Copyright (c) 2015, 2022, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 2.0, as published by the
 * Free Software Foundation.
 *
 * This program is also distributed with certain software (including but not
 * limited to OpenSSL) that is licensed under separate terms, as designated in a
 * particular file or component or in included license documentation. The
 * authors of MySQL hereby grant you an additional permission to link the
 * program and your derivative works with the separately licensed software that
 * they have included with MySQL.
 *
 * Without limiting anything contained in the foregoing, this file, which is
 * part of MySQL Connector/J, is also subject to the Universal FOSS Exception,
 * version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0,
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx_session.proto

public final class MysqlxSession {
  private MysqlxSession() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface AuthenticateStartOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Session.AuthenticateStart)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     ** authentication mechanism name 
     * </pre>
     *
     * <code>required string mech_name = 1;</code>
     * @return Whether the mechName field is set.
     */
    boolean hasMechName();
    /**
     * <pre>
     ** authentication mechanism name 
     * </pre>
     *
     * <code>required string mech_name = 1;</code>
     * @return The mechName.
     */
    java.lang.String getMechName();
    /**
     * <pre>
     ** authentication mechanism name 
     * </pre>
     *
     * <code>required string mech_name = 1;</code>
     * @return The bytes for mechName.
     */
    com.google.protobuf.ByteString
        getMechNameBytes();

    /**
     * <pre>
     ** authentication data 
     * </pre>
     *
     * <code>optional bytes auth_data = 2;</code>
     * @return Whether the authData field is set.
     */
    boolean hasAuthData();
    /**
     * <pre>
     ** authentication data 
     * </pre>
     *
     * <code>optional bytes auth_data = 2;</code>
     * @return The authData.
     */
    com.google.protobuf.ByteString getAuthData();

    /**
     * <pre>
     ** initial response 
     * </pre>
     *
     * <code>optional bytes initial_response = 3;</code>
     * @return Whether the initialResponse field is set.
     */
    boolean hasInitialResponse();
    /**
     * <pre>
     ** initial response 
     * </pre>
     *
     * <code>optional bytes initial_response = 3;</code>
     * @return The initialResponse.
     */
    com.google.protobuf.ByteString getInitialResponse();
  }
  /**
   * <pre>
   **
   *The initial message send from the client to the server to start
   *the authentication process.
   *&#64;returns &#64;ref Mysqlx::Session::AuthenticateContinue
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Session.AuthenticateStart}
   */
  public static final class AuthenticateStart extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Session.AuthenticateStart)
      AuthenticateStartOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use AuthenticateStart.newBuilder() to construct.
    private AuthenticateStart(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private AuthenticateStart() {
      mechName_ = "";
      authData_ = com.google.protobuf.ByteString.EMPTY;
      initialResponse_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new AuthenticateStart();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateStart_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateStart_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart.class, com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart.Builder.class);
    }

    private int bitField0_;
    public static final int MECH_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object mechName_;
    /**
     * <pre>
     ** authentication mechanism name 
     * </pre>
     *
     * <code>required string mech_name = 1;</code>
     * @return Whether the mechName field is set.
     */
    @java.lang.Override
    public boolean hasMechName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     ** authentication mechanism name 
     * </pre>
     *
     * <code>required string mech_name = 1;</code>
     * @return The mechName.
     */
    @java.lang.Override
    public java.lang.String getMechName() {
      java.lang.Object ref = mechName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          mechName_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     ** authentication mechanism name 
     * </pre>
     *
     * <code>required string mech_name = 1;</code>
     * @return The bytes for mechName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getMechNameBytes() {
      java.lang.Object ref = mechName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        mechName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AUTH_DATA_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString authData_;
    /**
     * <pre>
     ** authentication data 
     * </pre>
     *
     * <code>optional bytes auth_data = 2;</code>
     * @return Whether the authData field is set.
     */
    @java.lang.Override
    public boolean hasAuthData() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     ** authentication data 
     * </pre>
     *
     * <code>optional bytes auth_data = 2;</code>
     * @return The authData.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAuthData() {
      return authData_;
    }

    public static final int INITIAL_RESPONSE_FIELD_NUMBER = 3;
    private com.google.protobuf.ByteString initialResponse_;
    /**
     * <pre>
     ** initial response 
     * </pre>
     *
     * <code>optional bytes initial_response = 3;</code>
     * @return Whether the initialResponse field is set.
     */
    @java.lang.Override
    public boolean hasInitialResponse() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     ** initial response 
     * </pre>
     *
     * <code>optional bytes initial_response = 3;</code>
     * @return The initialResponse.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInitialResponse() {
      return initialResponse_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasMechName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mechName_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeBytes(2, authData_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBytes(3, initialResponse_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mechName_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, authData_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, initialResponse_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart other = (com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart) obj;

      if (hasMechName() != other.hasMechName()) return false;
      if (hasMechName()) {
        if (!getMechName()
            .equals(other.getMechName())) return false;
      }
      if (hasAuthData() != other.hasAuthData()) return false;
      if (hasAuthData()) {
        if (!getAuthData()
            .equals(other.getAuthData())) return false;
      }
      if (hasInitialResponse() != other.hasInitialResponse()) return false;
      if (hasInitialResponse()) {
        if (!getInitialResponse()
            .equals(other.getInitialResponse())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMechName()) {
        hash = (37 * hash) + MECH_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getMechName().hashCode();
      }
      if (hasAuthData()) {
        hash = (37 * hash) + AUTH_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getAuthData().hashCode();
      }
      if (hasInitialResponse()) {
        hash = (37 * hash) + INITIAL_RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getInitialResponse().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     **
     *The initial message send from the client to the server to start
     *the authentication process.
     *&#64;returns &#64;ref Mysqlx::Session::AuthenticateContinue
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Session.AuthenticateStart}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Session.AuthenticateStart)
        com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStartOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateStart_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateStart_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart.class, com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        mechName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        authData_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        initialResponse_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateStart_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart build() {
        com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart result = new com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.mechName_ = mechName_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.authData_ = authData_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000004;
        }
        result.initialResponse_ = initialResponse_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart.getDefaultInstance()) return this;
        if (other.hasMechName()) {
          bitField0_ |= 0x00000001;
          mechName_ = other.mechName_;
          onChanged();
        }
        if (other.hasAuthData()) {
          setAuthData(other.getAuthData());
        }
        if (other.hasInitialResponse()) {
          setInitialResponse(other.getInitialResponse());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasMechName()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                mechName_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                authData_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                initialResponse_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object mechName_ = "";
      /**
       * <pre>
       ** authentication mechanism name 
       * </pre>
       *
       * <code>required string mech_name = 1;</code>
       * @return Whether the mechName field is set.
       */
      public boolean hasMechName() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       ** authentication mechanism name 
       * </pre>
       *
       * <code>required string mech_name = 1;</code>
       * @return The mechName.
       */
      public java.lang.String getMechName() {
        java.lang.Object ref = mechName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            mechName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       ** authentication mechanism name 
       * </pre>
       *
       * <code>required string mech_name = 1;</code>
       * @return The bytes for mechName.
       */
      public com.google.protobuf.ByteString
          getMechNameBytes() {
        java.lang.Object ref = mechName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          mechName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       ** authentication mechanism name 
       * </pre>
       *
       * <code>required string mech_name = 1;</code>
       * @param value The mechName to set.
       * @return This builder for chaining.
       */
      public Builder setMechName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        mechName_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** authentication mechanism name 
       * </pre>
       *
       * <code>required string mech_name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearMechName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        mechName_ = getDefaultInstance().getMechName();
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** authentication mechanism name 
       * </pre>
       *
       * <code>required string mech_name = 1;</code>
       * @param value The bytes for mechName to set.
       * @return This builder for chaining.
       */
      public Builder setMechNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        mechName_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString authData_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       ** authentication data 
       * </pre>
       *
       * <code>optional bytes auth_data = 2;</code>
       * @return Whether the authData field is set.
       */
      @java.lang.Override
      public boolean hasAuthData() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       ** authentication data 
       * </pre>
       *
       * <code>optional bytes auth_data = 2;</code>
       * @return The authData.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAuthData() {
        return authData_;
      }
      /**
       * <pre>
       ** authentication data 
       * </pre>
       *
       * <code>optional bytes auth_data = 2;</code>
       * @param value The authData to set.
       * @return This builder for chaining.
       */
      public Builder setAuthData(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        authData_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** authentication data 
       * </pre>
       *
       * <code>optional bytes auth_data = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearAuthData() {
        bitField0_ = (bitField0_ & ~0x00000002);
        authData_ = getDefaultInstance().getAuthData();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString initialResponse_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       ** initial response 
       * </pre>
       *
       * <code>optional bytes initial_response = 3;</code>
       * @return Whether the initialResponse field is set.
       */
      @java.lang.Override
      public boolean hasInitialResponse() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       ** initial response 
       * </pre>
       *
       * <code>optional bytes initial_response = 3;</code>
       * @return The initialResponse.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getInitialResponse() {
        return initialResponse_;
      }
      /**
       * <pre>
       ** initial response 
       * </pre>
       *
       * <code>optional bytes initial_response = 3;</code>
       * @param value The initialResponse to set.
       * @return This builder for chaining.
       */
      public Builder setInitialResponse(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        initialResponse_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** initial response 
       * </pre>
       *
       * <code>optional bytes initial_response = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearInitialResponse() {
        bitField0_ = (bitField0_ & ~0x00000004);
        initialResponse_ = getDefaultInstance().getInitialResponse();
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Session.AuthenticateStart)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Session.AuthenticateStart)
    private static final com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart();
    }

    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<AuthenticateStart>
        PARSER = new com.google.protobuf.AbstractParser<AuthenticateStart>() {
      @java.lang.Override
      public AuthenticateStart parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<AuthenticateStart> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AuthenticateStart> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateStart getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AuthenticateContinueOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Session.AuthenticateContinue)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     ** authentication data 
     * </pre>
     *
     * <code>required bytes auth_data = 1;</code>
     * @return Whether the authData field is set.
     */
    boolean hasAuthData();
    /**
     * <pre>
     ** authentication data 
     * </pre>
     *
     * <code>required bytes auth_data = 1;</code>
     * @return The authData.
     */
    com.google.protobuf.ByteString getAuthData();
  }
  /**
   * <pre>
   **
   *Send by client or server after an &#64;ref Mysqlx::Session::AuthenticateStart
   *to exchange more authentication data.
   *&#64;returns Mysqlx::Session::AuthenticateContinue
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Session.AuthenticateContinue}
   */
  public static final class AuthenticateContinue extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Session.AuthenticateContinue)
      AuthenticateContinueOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use AuthenticateContinue.newBuilder() to construct.
    private AuthenticateContinue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private AuthenticateContinue() {
      authData_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new AuthenticateContinue();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateContinue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateContinue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue.class, com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue.Builder.class);
    }

    private int bitField0_;
    public static final int AUTH_DATA_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString authData_;
    /**
     * <pre>
     ** authentication data 
     * </pre>
     *
     * <code>required bytes auth_data = 1;</code>
     * @return Whether the authData field is set.
     */
    @java.lang.Override
    public boolean hasAuthData() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     ** authentication data 
     * </pre>
     *
     * <code>required bytes auth_data = 1;</code>
     * @return The authData.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAuthData() {
      return authData_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasAuthData()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeBytes(1, authData_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, authData_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue other = (com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue) obj;

      if (hasAuthData() != other.hasAuthData()) return false;
      if (hasAuthData()) {
        if (!getAuthData()
            .equals(other.getAuthData())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAuthData()) {
        hash = (37 * hash) + AUTH_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getAuthData().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     **
     *Send by client or server after an &#64;ref Mysqlx::Session::AuthenticateStart
     *to exchange more authentication data.
     *&#64;returns Mysqlx::Session::AuthenticateContinue
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Session.AuthenticateContinue}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Session.AuthenticateContinue)
        com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateContinue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateContinue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue.class, com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        authData_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateContinue_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue build() {
        com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue result = new com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.authData_ = authData_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue.getDefaultInstance()) return this;
        if (other.hasAuthData()) {
          setAuthData(other.getAuthData());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasAuthData()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                authData_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.ByteString authData_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       ** authentication data 
       * </pre>
       *
       * <code>required bytes auth_data = 1;</code>
       * @return Whether the authData field is set.
       */
      @java.lang.Override
      public boolean hasAuthData() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       ** authentication data 
       * </pre>
       *
       * <code>required bytes auth_data = 1;</code>
       * @return The authData.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAuthData() {
        return authData_;
      }
      /**
       * <pre>
       ** authentication data 
       * </pre>
       *
       * <code>required bytes auth_data = 1;</code>
       * @param value The authData to set.
       * @return This builder for chaining.
       */
      public Builder setAuthData(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        authData_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** authentication data 
       * </pre>
       *
       * <code>required bytes auth_data = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearAuthData() {
        bitField0_ = (bitField0_ & ~0x00000001);
        authData_ = getDefaultInstance().getAuthData();
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Session.AuthenticateContinue)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Session.AuthenticateContinue)
    private static final com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue();
    }

    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<AuthenticateContinue>
        PARSER = new com.google.protobuf.AbstractParser<AuthenticateContinue>() {
      @java.lang.Override
      public AuthenticateContinue parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<AuthenticateContinue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AuthenticateContinue> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateContinue getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AuthenticateOkOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Session.AuthenticateOk)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     ** authentication data 
     * </pre>
     *
     * <code>optional bytes auth_data = 1;</code>
     * @return Whether the authData field is set.
     */
    boolean hasAuthData();
    /**
     * <pre>
     ** authentication data 
     * </pre>
     *
     * <code>optional bytes auth_data = 1;</code>
     * @return The authData.
     */
    com.google.protobuf.ByteString getAuthData();
  }
  /**
   * <pre>
   **
   *Sent by the server after successful authentication.
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Session.AuthenticateOk}
   */
  public static final class AuthenticateOk extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Session.AuthenticateOk)
      AuthenticateOkOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use AuthenticateOk.newBuilder() to construct.
    private AuthenticateOk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private AuthenticateOk() {
      authData_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new AuthenticateOk();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateOk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateOk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk.class, com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk.Builder.class);
    }

    private int bitField0_;
    public static final int AUTH_DATA_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString authData_;
    /**
     * <pre>
     ** authentication data 
     * </pre>
     *
     * <code>optional bytes auth_data = 1;</code>
     * @return Whether the authData field is set.
     */
    @java.lang.Override
    public boolean hasAuthData() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     ** authentication data 
     * </pre>
     *
     * <code>optional bytes auth_data = 1;</code>
     * @return The authData.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAuthData() {
      return authData_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeBytes(1, authData_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, authData_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk other = (com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk) obj;

      if (hasAuthData() != other.hasAuthData()) return false;
      if (hasAuthData()) {
        if (!getAuthData()
            .equals(other.getAuthData())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAuthData()) {
        hash = (37 * hash) + AUTH_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getAuthData().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     **
     *Sent by the server after successful authentication.
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Session.AuthenticateOk}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Session.AuthenticateOk)
        com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOkOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateOk_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateOk_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk.class, com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        authData_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateOk_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk build() {
        com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk result = new com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.authData_ = authData_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk.getDefaultInstance()) return this;
        if (other.hasAuthData()) {
          setAuthData(other.getAuthData());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                authData_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.ByteString authData_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       ** authentication data 
       * </pre>
       *
       * <code>optional bytes auth_data = 1;</code>
       * @return Whether the authData field is set.
       */
      @java.lang.Override
      public boolean hasAuthData() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       ** authentication data 
       * </pre>
       *
       * <code>optional bytes auth_data = 1;</code>
       * @return The authData.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAuthData() {
        return authData_;
      }
      /**
       * <pre>
       ** authentication data 
       * </pre>
       *
       * <code>optional bytes auth_data = 1;</code>
       * @param value The authData to set.
       * @return This builder for chaining.
       */
      public Builder setAuthData(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        authData_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** authentication data 
       * </pre>
       *
       * <code>optional bytes auth_data = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearAuthData() {
        bitField0_ = (bitField0_ & ~0x00000001);
        authData_ = getDefaultInstance().getAuthData();
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Session.AuthenticateOk)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Session.AuthenticateOk)
    private static final com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk();
    }

    public static com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<AuthenticateOk>
        PARSER = new com.google.protobuf.AbstractParser<AuthenticateOk>() {
      @java.lang.Override
      public AuthenticateOk parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<AuthenticateOk> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AuthenticateOk> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxSession.AuthenticateOk getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResetOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Session.Reset)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     ** if is true the session will be reset, but stays authenticated; otherwise,
     *the session will be closed and needs to be authenticated again 
     * </pre>
     *
     * <code>optional bool keep_open = 1 [default = false];</code>
     * @return Whether the keepOpen field is set.
     */
    boolean hasKeepOpen();
    /**
     * <pre>
     ** if is true the session will be reset, but stays authenticated; otherwise,
     *the session will be closed and needs to be authenticated again 
     * </pre>
     *
     * <code>optional bool keep_open = 1 [default = false];</code>
     * @return The keepOpen.
     */
    boolean getKeepOpen();
  }
  /**
   * <pre>
   **
   *Reset the current session.
   *&#64;returns &#64;ref Mysqlx::Ok
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Session.Reset}
   */
  public static final class Reset extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Session.Reset)
      ResetOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Reset.newBuilder() to construct.
    private Reset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Reset() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Reset();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Reset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Reset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxSession.Reset.class, com.mysql.cj.x.protobuf.MysqlxSession.Reset.Builder.class);
    }

    private int bitField0_;
    public static final int KEEP_OPEN_FIELD_NUMBER = 1;
    private boolean keepOpen_;
    /**
     * <pre>
     ** if is true the session will be reset, but stays authenticated; otherwise,
     *the session will be closed and needs to be authenticated again 
     * </pre>
     *
     * <code>optional bool keep_open = 1 [default = false];</code>
     * @return Whether the keepOpen field is set.
     */
    @java.lang.Override
    public boolean hasKeepOpen() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     ** if is true the session will be reset, but stays authenticated; otherwise,
     *the session will be closed and needs to be authenticated again 
     * </pre>
     *
     * <code>optional bool keep_open = 1 [default = false];</code>
     * @return The keepOpen.
     */
    @java.lang.Override
    public boolean getKeepOpen() {
      return keepOpen_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeBool(1, keepOpen_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, keepOpen_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxSession.Reset)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxSession.Reset other = (com.mysql.cj.x.protobuf.MysqlxSession.Reset) obj;

      if (hasKeepOpen() != other.hasKeepOpen()) return false;
      if (hasKeepOpen()) {
        if (getKeepOpen()
            != other.getKeepOpen()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKeepOpen()) {
        hash = (37 * hash) + KEEP_OPEN_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getKeepOpen());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxSession.Reset prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     **
     *Reset the current session.
     *&#64;returns &#64;ref Mysqlx::Ok
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Session.Reset}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Session.Reset)
        com.mysql.cj.x.protobuf.MysqlxSession.ResetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Reset_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Reset_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxSession.Reset.class, com.mysql.cj.x.protobuf.MysqlxSession.Reset.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxSession.Reset.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        keepOpen_ = false;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Reset_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.Reset getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxSession.Reset.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.Reset build() {
        com.mysql.cj.x.protobuf.MysqlxSession.Reset result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.Reset buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxSession.Reset result = new com.mysql.cj.x.protobuf.MysqlxSession.Reset(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.keepOpen_ = keepOpen_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxSession.Reset) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxSession.Reset)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxSession.Reset other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxSession.Reset.getDefaultInstance()) return this;
        if (other.hasKeepOpen()) {
          setKeepOpen(other.getKeepOpen());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                keepOpen_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private boolean keepOpen_ ;
      /**
       * <pre>
       ** if is true the session will be reset, but stays authenticated; otherwise,
       *the session will be closed and needs to be authenticated again 
       * </pre>
       *
       * <code>optional bool keep_open = 1 [default = false];</code>
       * @return Whether the keepOpen field is set.
       */
      @java.lang.Override
      public boolean hasKeepOpen() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       ** if is true the session will be reset, but stays authenticated; otherwise,
       *the session will be closed and needs to be authenticated again 
       * </pre>
       *
       * <code>optional bool keep_open = 1 [default = false];</code>
       * @return The keepOpen.
       */
      @java.lang.Override
      public boolean getKeepOpen() {
        return keepOpen_;
      }
      /**
       * <pre>
       ** if is true the session will be reset, but stays authenticated; otherwise,
       *the session will be closed and needs to be authenticated again 
       * </pre>
       *
       * <code>optional bool keep_open = 1 [default = false];</code>
       * @param value The keepOpen to set.
       * @return This builder for chaining.
       */
      public Builder setKeepOpen(boolean value) {
        bitField0_ |= 0x00000001;
        keepOpen_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** if is true the session will be reset, but stays authenticated; otherwise,
       *the session will be closed and needs to be authenticated again 
       * </pre>
       *
       * <code>optional bool keep_open = 1 [default = false];</code>
       * @return This builder for chaining.
       */
      public Builder clearKeepOpen() {
        bitField0_ = (bitField0_ & ~0x00000001);
        keepOpen_ = false;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Session.Reset)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Session.Reset)
    private static final com.mysql.cj.x.protobuf.MysqlxSession.Reset DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxSession.Reset();
    }

    public static com.mysql.cj.x.protobuf.MysqlxSession.Reset getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<Reset>
        PARSER = new com.google.protobuf.AbstractParser<Reset>() {
      @java.lang.Override
      public Reset parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Reset> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Reset> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxSession.Reset getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CloseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Session.Close)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * <pre>
   **
   *Close the current session.
   *&#64;returns &#64;ref Mysqlx::Ok
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Session.Close}
   */
  public static final class Close extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Session.Close)
      CloseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Close.newBuilder() to construct.
    private Close(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Close() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Close();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Close_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Close_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxSession.Close.class, com.mysql.cj.x.protobuf.MysqlxSession.Close.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxSession.Close)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxSession.Close other = (com.mysql.cj.x.protobuf.MysqlxSession.Close) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxSession.Close parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Close parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Close parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Close parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Close parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Close parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Close parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Close parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Close parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Close parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Close parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSession.Close parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxSession.Close prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     **
     *Close the current session.
     *&#64;returns &#64;ref Mysqlx::Ok
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Session.Close}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Session.Close)
        com.mysql.cj.x.protobuf.MysqlxSession.CloseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Close_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Close_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxSession.Close.class, com.mysql.cj.x.protobuf.MysqlxSession.Close.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxSession.Close.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Close_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.Close getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxSession.Close.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.Close build() {
        com.mysql.cj.x.protobuf.MysqlxSession.Close result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSession.Close buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxSession.Close result = new com.mysql.cj.x.protobuf.MysqlxSession.Close(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxSession.Close) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxSession.Close)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxSession.Close other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxSession.Close.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Session.Close)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Session.Close)
    private static final com.mysql.cj.x.protobuf.MysqlxSession.Close DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxSession.Close();
    }

    public static com.mysql.cj.x.protobuf.MysqlxSession.Close getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<Close>
        PARSER = new com.google.protobuf.AbstractParser<Close>() {
      @java.lang.Override
      public Close parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Close> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Close> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxSession.Close getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Session_AuthenticateStart_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Session_AuthenticateStart_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Session_AuthenticateContinue_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Session_AuthenticateContinue_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Session_AuthenticateOk_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Session_AuthenticateOk_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Session_Reset_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Session_Reset_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Session_Close_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Session_Close_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\024mysqlx_session.proto\022\016Mysqlx.Session\032\014" +
      "mysqlx.proto\"Y\n\021AuthenticateStart\022\021\n\tmec" +
      "h_name\030\001 \002(\t\022\021\n\tauth_data\030\002 \001(\014\022\030\n\020initi" +
      "al_response\030\003 \001(\014:\004\210\3520\004\"3\n\024AuthenticateC" +
      "ontinue\022\021\n\tauth_data\030\001 \002(\014:\010\220\3520\003\210\3520\005\")\n\016" +
      "AuthenticateOk\022\021\n\tauth_data\030\001 \001(\014:\004\220\3520\004\"" +
      "\'\n\005Reset\022\030\n\tkeep_open\030\001 \001(\010:\005false:\004\210\3520\006" +
      "\"\r\n\005Close:\004\210\3520\007B\031\n\027com.mysql.cj.x.protob" +
      "uf"
    };
    descriptor = com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.x.protobuf.Mysqlx.getDescriptor(),
        });
    internal_static_Mysqlx_Session_AuthenticateStart_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Session_AuthenticateStart_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Session_AuthenticateStart_descriptor,
        new java.lang.String[] { "MechName", "AuthData", "InitialResponse", });
    internal_static_Mysqlx_Session_AuthenticateContinue_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Session_AuthenticateContinue_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Session_AuthenticateContinue_descriptor,
        new java.lang.String[] { "AuthData", });
    internal_static_Mysqlx_Session_AuthenticateOk_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Session_AuthenticateOk_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Session_AuthenticateOk_descriptor,
        new java.lang.String[] { "AuthData", });
    internal_static_Mysqlx_Session_Reset_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Session_Reset_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Session_Reset_descriptor,
        new java.lang.String[] { "KeepOpen", });
    internal_static_Mysqlx_Session_Close_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_Mysqlx_Session_Close_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Session_Close_descriptor,
        new java.lang.String[] { });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.mysql.cj.x.protobuf.Mysqlx.clientMessageId);
    registry.add(com.mysql.cj.x.protobuf.Mysqlx.serverMessageId);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    com.mysql.cj.x.protobuf.Mysqlx.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
