// Exemple de persistance des instances d'une classe (Personne) dans une base de données MySQL.
//   Cet exemple n'utilise pas les notations mais un fichier de configuration :
//      Personne.hbm.xml
//
import org.hibernate.*;
import org.hibernate.cfg.*;
import java.sql.*;
import java.util.*;

import fr.cnam.test.*;
import fr.cnam.ihm.*;
import fr.cnam.tore.*;

public class Exemple02 implements FormulaireInt
{ 
  Configuration       config ;
  SessionFactory      sessionFactory;
  ArrayList<Personne> liste;
  Formulaire          form;
  Session             sessionPersist;

  // Ce programe 
  //    permet de verifier l'utilisation en sauvegarde/chagerment
  //    et en mode persistance
  //
  public static void main(String[] args) throws Exception
  {
    // Creation de l'exemple
    new Exemple02();
  }

  public Exemple02()
  {
    // ------------ Configuration de la persistance
    //
    config = new Configuration();
    // Configuration du mapping de la classe Personne
    config.addClass(fr.cnam.test.Personne.class);
    // Va chercher le fichier Personne.hbm.xml
    
    // Configuration de la session avec la base de données : 
    //    voir le contenu du fichier hibernate.cfg.xml
    sessionFactory = config.configure("hibernate.cfg.xml").buildSessionFactory();

    // pour tester la persistance
    
    // ----------- Initialisation du metier
    liste=new ArrayList<Personne>();
    liste.add(new Personne("LAFONT","Pierre",32));
    liste.add(new Personne("DUPONT","Paul",46));
    liste.add(new Personne("ROCKY","Balboa",75));

    // ----------- Initialisation de l'IHM
    form = new Formulaire("PERSITANCE 1",this,700,600,true);
    form.addText("NOM","Nom",true,"");
    form.addText("PRENOM","Prenom",true,"");
    form.addText("AGE","Age",true,"");
    form.addButton("AJOUTER","Ajouter");
    form.addText("ID","Id",true,"");
    form.addButton("MODIFIER","Modifier");
    form.addButton("LISTER","Lister");

    form.addLabel("");
    form.addButton("SAUVER","Sauver");
    form.addButton("CHARGER","Charger");
    form.addLabel("");
    form.addButton("LECTURE_BASE","Lecture base");
    form.addLabel("");
    form.addButton("PERSIST","Persist");
    form.addButton("FLUSH","Flush");
    form.setPosition(250,0);
    form.addZoneText("RESULTAT",
                     "Resultat",
                     false,
                     "",
                     400,
                     600);
    form.afficher();
  }

  public void submit(Formulaire form,String nomSubmit)
  {
    if (nomSubmit.equals("AJOUTER"))
      {
        String nom    = form.getValeurChamp("NOM");
        String prenom = form.getValeurChamp("PRENOM");
        int    age    = Integer.parseInt(form.getValeurChamp("AGE"));
        liste.add(new Personne(nom,prenom,age));
        lister();
      }

    if (nomSubmit.equals("MODIFIER"))
      {
        String nom    = form.getValeurChamp("NOM");
        String prenom = form.getValeurChamp("PRENOM");
        int    age    = Integer.parseInt(form.getValeurChamp("AGE"));
        int    id     = Integer.parseInt(form.getValeurChamp("ID"));
        
        for(Personne p:liste)
          if(p.getId()==id){
            p.setNom(nom);
            p.setPrenom(prenom);
            p.setAge(age);
            break;
          }
        lister();
      }
    
    if (nomSubmit.equals("LISTER"))
      {
        lister();
      }

    if (nomSubmit.equals("SAUVER"))
      {
        // Ouverture de la session
        Session session = sessionFactory.openSession();
                
        //
        Transaction tx = null; 
        try { 
          tx = session.beginTransaction(); 
          for(Personne p:liste) 
            session.saveOrUpdate(p);
          session.flush();
          tx.commit();
        } catch (Exception e) {
          if (tx != null) {
            tx.rollback();
          }
          throw e;
        } finally { 
          session.close(); 
        } 
      } 
    
    if (nomSubmit.equals("PERSIST"))
      {
        // Ouverture de la session de persistance (a faire qu'1 fois)
        sessionPersist = sessionFactory.openSession();
                
        try { 
          for(Personne p:liste) try{sessionPersist.persist(p);}catch(Exception ex){}
          sessionPersist.flush();
        } catch (Exception e) {
          throw e;
        } finally { 
        } 
      } 

    if (nomSubmit.equals("FLUSH"))
      {
        sessionPersist.flush();
      }
    
    if (nomSubmit.equals("CHARGER"))
      {
        Session session = sessionFactory.openSession();
                
        // 
        liste.clear();
        int id=1;
        while(true)
          {
            Personne p = (Personne)session.get(Personne.class,id);
            if(p==null) break;
            liste.add(p);
            id=id+1;
          }
        
        session.close(); 

        lister();
      }

    if (nomSubmit.equals("LECTURE_BASE"))
      {
        Session session = sessionFactory.openSession();
        String res="";
        int id=1;
        while(true)
          {
            Personne p = (Personne)session.get(Personne.class,id);
            if(p==null) break;
            res = res+p.toString()+"\n";
            id=id+1;
          }
        form.setValeurChamp("RESULTAT",res);
        session.close(); 
      }
  }

  public String lister() {
    String res="";
    for(Personne p:liste)res=res+p.toString()+"\n";
    form.setValeurChamp("RESULTAT",res);
    return res;
  }

  public void exit()
  {
    sessionFactory.close();
  }

}