// Cet exemple reprend l exemple du cours (Employe, Departement, Projet)
// Mis en evidence de la persistances des liens d'association entre les objets.
//
//   Cet exemple utilise les notations. L'objet est persistant dans la session d'hibernate
//
import org.hibernate.*;
import org.hibernate.cfg.*;
import java.sql.*;
import java.util.*;

import fr.cnam.test.*;
import fr.cnam.util.*;

public class Exemple04
{ 
    public static void main(String[] args) throws Exception
    {
        java.util.logging.Logger.getLogger("org.hibernate").setLevel(java.util.logging.Level.OFF);

        // Creation des objets : run1.bat
        //
        if (args[0].equals("creer"))
            {
                Configuration config = new Configuration();
                SessionFactory sessionFactory = config.configure("hibernate.cfg.xml").buildSessionFactory();
                Session session = sessionFactory.openSession();

                try { 
                    //
                    Departement dep = (Departement)session.get(Departement.class,1);
                    if (dep==null)
                        dep=new Departement(1,"Physique","Toulouse");
                        
                    session.persist(dep);


                    // Si on execute une 2eme fois, les elements ne sont pas
                    //  ajoutes une 2eme fois car la collection est un Set
                    //
                    //
                    Employe e1 = new Employe(123,"LAFORGUE", "Jacques", "30/09/1991",
                                             new Contrat(10),
                                             new Contact("0561722050","xx","yy"));
                    Employe e2 = new Employe(245,"LAFONT", "Pierre", "31/10/1980",
                                             new Contrat(11),
                                             new Contact("0612345678","aa","bb"));
                    Employe e3 = new Employe(246,"DUPONT", "Jules", "22/01/1983",
                                             new Contrat(12),
                                             new Contact("0578452367","dd","ff"));
                    Employe e4 = new Employe(247,"DURAND", "Jules", "22/01/1983",
                                             new Contrat(13),
                                             new Contact("0678563423","",""));

                    dep.ajouterEmploye(e1);
                    dep.ajouterEmploye(e2);
                    dep.ajouterEmploye(e3);
                    dep.ajouterEmploye(e4);

                    e2.setSuperieur(e1);
                    e3.setSuperieur(e2);
                    e4.setSuperieur(e2);

                    Projet p1 = new Projet("RD15001","Drone surveillance");
                    Projet p2 = new Projet("FR15001","Cours NFA031");
                    Projet p3 = new Projet("FR15002","Cours NFA032");

                    dep.ajouterProjet(p1);
                    dep.ajouterProjet(p2);
                    dep.ajouterProjet(p3);
                    
                    p1.ajouterEmploye(e2);
                    p2.ajouterEmploye(e2);
                    p3.ajouterEmploye(e2);
                    p1.ajouterEmploye(e1);
                    p1.ajouterEmploye(e3);
                    p2.ajouterEmploye(e3);


                    // Affichage du departement
                    dep.aff();
                    // On peut remarquer que la 1ere fois, les Id sont nulls car pas 
                    // encore déterminés par une ecriture en base de donnees

                    System.out.println("Avant flush");
                    Terminal.lireString();

                    // Ecriture en base de donnees
                    session.flush();   
                    dep.supprimerEmploye(123);
                    
                    System.out.println("******* APRES SUPPRESSION ****");
                    dep.aff();
                    
                    // Ecriture en base de donnees
                    System.out.println("Avant flush");
                    Terminal.lireString();
                    session.flush();   

                    
                } catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                } finally { 
                    session.close(); 
                } 
                
                sessionFactory.close(); 
            } //creer

        
        // Lecture des objets : run2.bat
        //
        if (args[0].equals("lire"))
            {
                Configuration config = new Configuration();
                SessionFactory sessionFactory = config.configure("hibernate.cfg.xml").buildSessionFactory();
                Session session = sessionFactory.openSession();

                System.out.println("======  FINDER ============");
                Scanner sc = new Scanner(System.in);
                System.out.println("Chercher:");
                String choix = Terminal.lireString();
                List<Employe> l = Employe.finder(session,choix);
                for(Employe e:l) e.aff();
                System.out.println("===========================");
                
                // Acces au 1er departement
                Departement dep = (Departement)session.get(Departement.class,1);

                // Affichage du departement
                dep.aff();
                
                session.close();
                
                sessionFactory.close(); 

            }//lire
    }//main
}//class