package fr.cnam.util;

import java.io.*;
import java.util.*;

/** La classe Terminal permet de raliser ses premiers programmes Java en permettant d'afficher dans la console d'excution des donnes de type diffrents, et en permettant de saisir au clavier des donnes de type diffrents.<BR>
    Elle permet aussi de lire et crire un fichier texte
    Cette classe contient que des mthodes statiques. */
public class Terminal{    

    // Le buffer standard  de lecture = le clavier
    private static BufferedReader in =
        new BufferedReader(new InputStreamReader(System.in));

    /** Cette mthode lit un fichier texte et retourne le contenu du fichier sous la forme d'un  tableau de String dont chaque element est une ligne du fichier.
        @param nomFichier le nom du fichier qui doit tre dans le rpertoire courant.
        @return String[] le contenu du fichier. 
        @exception TerminalException (de type RuntimeException) si erreur d'criture<BR>
        Rappel : Une exception de type RuntimeException n'a pas l'obligation d'tre capture.
*/
    public static String[] lireFichierTexte(String nomFichier)
    {
        try{
            File fichier = new File(nomFichier);
            FileInputStream fis = new FileInputStream(new File(nomFichier));
            
            byte[] buffer = new byte[(int)fichier.length()];
            fis.read(buffer);
            fis.close();
            String str = new String(buffer);

            // On enleve le caractre '\r' code 13 qui est ajout en Windows
            // Les fins de ligne dans un fichier texte cr sous Windows
            //  se termine par \r\n.
            // Il faut enlever le \r car il a des effets perturbant sur
            //  la mthode System.out.print et est pris comme un caractre de plus
            //  qu'il faut liminer
            //  
            String texte = str.replaceAll(""+(char)(13),"");
            
            // Les lignes du fichier sont mises dans un tableau
            //
            String[] mots = texte.split("\n");

            return(mots);
        }
        catch(Exception ex)
            {
                exceptionHandler(ex);
            }
        return null;
    }

    /** Cette mthode permet de crer un fichier texte  partir du contenu d'un StringBuffer.
        @param nomFichier Le nom du fichier qui est cr dans le rpertoire courant
        @param strbuf Le StringBuffer contenant le texte  crire. 
        @exception TerminalException (de type RuntimeException) si erreur d'criture
    */
    public static void ecrireFichier(String nomFichier,
                                     StringBuffer strbuf)
    {
        try{
            File fichier = new File(nomFichier);
            FileOutputStream fos = new FileOutputStream(new File(nomFichier));
            
            byte[] buffer = strbuf.toString().getBytes();
            fos.write(buffer);
            fos.close();
        }
        catch(Exception ex)
            {
                exceptionHandler(ex);
            }
    }

    /** Cette mthode lit une chane de caractre
        @return String la chane saisie dans la console d'excution
       @exception TerminalException (de type RuntimeException) si erreur de lecture
    */
    public static String lireString() // Lire un String
    {
        String tmp="";
        char C='\0';
        try {
            tmp = in.readLine();
        }
        catch (IOException e)
            {
                exceptionHandler(e);
            }
        return tmp;
    }

    /** Cette mthode lit un entier
        @return int L'entier saisi dans la console d'excution
       @exception TerminalException (de type RuntimeException) si la saisie n'est pas un entier ou erreur de lecture
    */
    public static int lireInt()  // Lire un entier
    {
        int x=0;
        try {
            x=Integer.parseInt(lireString());
        }
        catch (NumberFormatException e) {
            exceptionHandler(e);
        }	
        return x ;
    }

    /** Cette mthode lit un boolean (false ou true)
        @return boolean Le boolean saisi dans la console d'excution
       @exception TerminalException (de type RuntimeException) si erreur de lecture. <BR>
       Tout autre valeur que TRUE, FALSE, true ou false, retourne la valeur false
    */
    public static boolean lireBoolean()  // Lire un entier
    {
        boolean b = true;
        try {
            b = Boolean.valueOf(lireString()).booleanValue();
        }
        catch (NumberFormatException e) {
            exceptionHandler(e);
        }	
        return b;
    }

    /** Cette mthode lit un double
        @return double Le double saisi dans la console d'excution
       @exception TerminalException (de type RuntimeException) si la valeur saisie n'est pas un double ou ereur de lecture.
    */
    public  static double lireDouble()  // Lire un double
    {
        double x=0.0;
        try {
            x=Double.valueOf(lireString()).doubleValue();
        }
        catch (NumberFormatException e) {
            exceptionHandler(e);
        }	
        return x ;
    }

    /** Cette mthode lit un caractre.
       @exception TerminalException (de type RuntimeException) si erreur de lecture.<BR>
       Si on saisit plus d'1 caractre alors le caractre retourn est le premier.
    */
    public  static char lireChar()  // Lire un caractere
    {
        String tmp=lireString();
        if (tmp.length()==0)
            return '\n';
        else 
            {
                return tmp.charAt(0);
            }
    }

    /** Cette mthode crit une chaine et ne revient pas  la ligne.
        @param s la chaine &agrave; &eacute;crire
    */
    public static void ecrireString(String s){ // Afficher un String
        System.out.print(s);
    }

    /** Cette mthode crit une chaine et revient  la ligne.
        @param s la chaine &agrave; &eacute;crire
    */
    public static void ecrireStringln(String s) // Afficher un String
    {
        ecrireString(s);
        sautDeLigne();
    }

    /** Cette mthode crit un entier et ne revient pas  la ligne.
        @param i l'entier  crire
    */
    public static void ecrireInt(int i)  // Afficher un entier
    {
        ecrireString(""+i);
    }

    /** Cette mthode crit un entier et revient  la ligne.
        @param i l'entier  crire
    */
    public static void ecrireIntln(int i)  // Afficher un entier
    {
        ecrireString(""+i);
        sautDeLigne();
    }

    /** Cette mthode crit un boolan et ne revient pas  la ligne.
        @param b le boolen  crire
    */
    public static void ecrireBoolean(boolean b){
        ecrireString(""+b);
    }

    /** Cette mthode crit un boolan et revient  la line.
        @param b le boolen  crire
    */
    public static void ecrireBooleanln(boolean b){
        ecrireString(""+b);
        sautDeLigne();
    }

    /** Cette mthode crit un double et ne revient pas  la ligne.
        @param d le double  crire
    */
    public  static void ecrireDouble(double d)  // Afficher un double
    {
        ecrireString(""+d);
    }

    /** Cette mthode crit un double et revient  la ligne.
        @param d le double  crire
    */
    public  static void ecrireDoubleln(double d)  // Afficher un double
    {
        ecrireDouble(d);
        sautDeLigne();
    }

    /** Cette mthode crit un caractre et ne revient pas  la ligne.
        @param c le caractre  crire
    */
    public  static void ecrireChar(char c)  // Afficher un caractere
    {
        ecrireString(""+c);
    }  

    /** Cette mthode crit un caractre et revient  la ligne.
        @param c le caractre  crire
    */
    public  static void ecrireCharln(char c)  // Afficher un caractere
    {
        ecrireChar(c);
        sautDeLigne();
    }

    /** Cette mthode revient  la ligne.
    */
    public static void sautDeLigne(){
        try{
            System.out.println();
        }catch(Exception ex){
            exceptionHandler(ex);
        }
    }

    /** Cette mthode retourne l'exception TerminalException
    */
    protected static void exceptionHandler(Exception ex){
        TerminalException err = new TerminalException(ex);
        throw err;
    }

    /** Cette mthode crit une exception avec la pile dans la console
        @param ex l'exception  crire
    */
    public static void ecrireException(Throwable ex){
        ecrireString(ex.toString());
        ex.printStackTrace(System.out);
    }
}  


