package fr.cnam.test;

import org.hibernate.*;
import org.hibernate.cfg.*;
import org.hibernate.transform.*;
import org.hibernate.criterion.*;

import javax.persistence.*;
import java.io.*;
import java.util.*;

// Classe de definition d'un commercial qui herite
//  de Employe
//
//@Entity
//@Table(name="Commercial")
@Entity
public class Commercial extends Employe implements Serializable
{
    @Column
        private Double commission;

    public Commercial(){}

    public Commercial(int matricule,
                      String nom,
                      String prenom,
                      String dateEmbauche,
                      Contrat contrat,
                      Contact contact,
                      double commission)
    {
        super(matricule,nom,prenom,dateEmbauche,contrat,contact);
        this.commission = commission;
    }

    // Chaine d'un commercial
    //
    public String toString()
    {
        return String.format("%s\n%15s : %9.2f",
                             super.toString(),
                             "Commission",commission);
    }

}
