package fr.cnam.test;

import org.hibernate.*;
import org.hibernate.cfg.*;
import org.hibernate.transform.*;

import javax.persistence.*;
import java.io.*;
import java.util.*;

// Classe de definition des elements pour 
//  contacter l'employe
//
@Embeddable
public class Contact implements Serializable
{
    // Il n'y a pas de Id car cette classe
    //  est Embedded (inclus dans la table 
    //  associe a l'instance d'appartenance


    // Nummero de telephone de l'employe
    @Column
    private String telephonePersonnel;
    
    // Adresse postale de l'employe
    @Column
    private String adressePostale;

    // Adresse mail de l'employe
    @Column
    private String adresseMail;


    // Constrcuteur par defaut
    public Contact(){}

    // Constructeur applicatif
    //
    public Contact(String tel,String adp, String adm)
    {
        telephonePersonnel = tel;
        adressePostale = adp;
        adresseMail = adm;
    }

    public String getTelephonePersonnel(){return telephonePersonnel;}
    public String getAdressePostale(){return adressePostale;}
    public String getAdresseMail(){return adresseMail;}
    
    public void setTelephonePersonnel(String tel){telephonePersonnel=tel;}
    public void setAdressePostale(String adr){adressePostale=adr;}
    public void setAdresseMail(String adr){adresseMail=adr;}

}