package fr.cnam.test;

import javax.persistence.*;
import java.util.*;
import java.io.*;

// Classe de definition d'un departement
//  qui contient des employes et des projets
//
//  Un employe appartient a un et un seul departement
//  Un employe peut appartenir a plusieurs projets
//
@Entity
@Table(name="Departement")
public class Departement implements Serializable
{
    // Clef de departement
    @Id
    @GeneratedValue
    private Integer idDep;    

    // Numero du departement
    // Le numero est unique et permet d'identifier
    //  le département parmi les autres
    @Column
        private Integer numero;   

    // Nom du departement
    @Column
        private String nom;      

    // Lieu du departement
    @Column
        private String lieu;    

    // La liste des employes du departement
    //
    // L'attribut orphanRemoval=true provoque la suppression des
    //  employes de la table qui ont été supprimes dans la collection
    //  (Cas du lien de composition et non d'agregation)
    //
    @OneToMany(cascade=CascadeType.ALL, fetch=FetchType.EAGER,orphanRemoval=true)
    @JoinColumn(name="idDepartement")
    private Set<AbstractEmploye> employes;

    // La liste des projets du departement
    //
    @OneToMany(cascade=CascadeType.ALL, fetch=FetchType.EAGER)
    @JoinColumn(name="idDepartement")
    private Set<Projet> projets;

    // Constructeur utilise par la persistance
    //
    public Departement()
    {
        idDep=0;
        numero=0;
        nom="";
        lieu="";
        employes = new HashSet<AbstractEmploye>();
        projets  = new HashSet<Projet>();
    }

    // Constructeur applicatif
    //
    public Departement(int numero,String nom,String lieu)
    {
        this.numero = numero;
        this.nom = nom;
        this.lieu = lieu;
        employes = new HashSet<AbstractEmploye>();
        projets  = new HashSet<Projet>();
    }

    // Ajouter un employe dans la collection
    //
    public void ajouterEmploye(AbstractEmploye employe)
    {
        employes.add(employe);
    }

    // Ajouter un projet dans la collection
    //
    public void ajouterProjet(Projet projet)
    {
        projets.add(projet);
    }

    // Suppression d'un employe
    //
    public void supprimerEmploye(Integer matricule)
    {
        // Suppression de l'employe de matricule
        employes.remove(new Employe(matricule));

        // Il faut aussi eventuellement supprimer cet
        //  employe des projets auquels il appartient
        for(Projet p:projets) p.supprimerEmploye(matricule);

        // Il faut aussi eventuellement mettre a jour
        //  les employes dont il est le superieur
        for(AbstractEmploye e:employes) 
            {
                AbstractEmploye sup = e.getSuperieur();
                if ( (sup!=null) &&
                     (e.getSuperieur().getMatricule().intValue()==matricule.intValue()))
                    e.setSuperieur(null);
            }
    }

    // Afficher un departement
    //
    public void aff()
    {
        System.out.println(String.format("Departement %d %s %s\n",
                                         numero,nom,lieu));
        for(AbstractEmploye e:employes) e.aff();
        for(Projet p:projets) p.aff();
    }
        
}
