package fr.cnam.test;

import org.hibernate.*;
import org.hibernate.cfg.*;
import org.hibernate.transform.*;
import org.hibernate.criterion.*;

import javax.persistence.*;
import java.io.*;
import java.util.*;

// Classe de definition d'un employe
//
@Entity @Inheritance(strategy=InheritanceType.SINGLE_TABLE)
//@Entity @Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
//@Entity @Inheritance(strategy=InheritanceType.JOINED)
public class Employe extends AbstractEmploye implements Serializable
{
    // Le numero de matricule de l'employe
    // Le numero de matricule est unique et permet d'identifier
    //  l 'employe parmi les autres
    @Column
        private Integer matricule;

    // Nom de l'employe
    @Column
        private String nom;     

    // Prenom de l'employe
    @Column
        private String prenom;   

    // Date d'embauche de l'employe
    @Column
        private String dateEmbauche;


    @OneToOne(cascade=CascadeType.ALL, fetch=FetchType.EAGER,orphanRemoval=true)
    @JoinColumn(name="contrat")   // Clef etrangere dans la table EMPLOYE
    private Contrat contrat;

    @OneToOne(cascade=CascadeType.ALL, fetch=FetchType.EAGER)
    @JoinColumn(name="superieur")   // Clef etrangere dans la table EMPLOYE
    private Employe superieur;

     @Embedded
     private Contact contact;

    // Cet attribut peut ne pas etre cree.
    //  Il correspond au lien bi-directionnel entre
    //   un projet et un employe
    //    abstract public AbstractEmploye getSuperieur();
    @Column
        private Integer idProjet;  


    // Constructeur utilise par Hibernate
    public Employe()
    {
        nom="";
        prenom="";
        dateEmbauche = null;
        superieur=null;
    }

    // Constructeur applicatif
    public Employe(int matricule,String nom,String prenom,String dateEmbauche,
                   Contrat contrat,
                   Contact contact)
    {
        this.matricule=matricule;
        this.nom=nom;
        this.prenom=prenom;
        this.dateEmbauche=dateEmbauche;
        this.contrat=contrat;
        this.contact=contact;
        this.superieur=null;
    }

    // Constructeur pour recherche ou suppression
    public Employe(int matricule)
    {
        this.matricule=matricule;
    }

    //  Defnition du critere d'unicite de la collectionSet
    //
    public boolean equals(Object e)
    {
        return ((AbstractEmploye)e).getMatricule().intValue()==matricule.intValue();
    }
    public int hashCode()  // Indispensable pour equals
    {
        return matricule.intValue();
    }
    


    public Integer getMatricule(){return matricule;}
    public void setMatricule(Integer matricule){this.matricule=matricule;}


    public String getNom(){return nom;}
    public String getPrenom(){return prenom;}
    public String getDateEmbauche(){return dateEmbauche;}
    public Contrat getContrat(){return contrat;}
    public Contact getContact(){return contact;}
    public Employe getSuperieur(){return superieur;}

    
    public void setNom(String nom){this.nom=nom;}
    public void setPrenom(String prenom){this.prenom=prenom;}
    public void setDateEmbauche(String dateEmbauche){this.dateEmbauche=dateEmbauche;}
    public void setContrat(Contrat c){contrat=c;}
    public void setContact(Contact c){contact=c;}
    public void setSuperieur(Employe e){superieur=e;}

    // 
    public String getTelephonePersonnel(){return contact.getTelephonePersonnel();}
    public String getAdressePostale(){return contact.getAdressePostale();}
    public String getAdresseMail(){return contact.getAdresseMail();}
    
    public void setTelephonePersonnel(String tel){contact.setTelephonePersonnel(tel);}
    public void setAdressePostale(String adr){contact.setAdressePostale(adr);}
    public void setAdresseMail(String adr){contact.setAdresseMail(adr);}



    // Chaine d'un employe
    //
    public String toString()
    {
        return String.format("%15s : %03d\n%15s : %03d\n%15s : %-30s\n%15s : %-30s\n%15s : %-10s\n%15s : %-15s\n%15s : %-15s",
                             "Id",getIdEmploye(),
                             "Matricule",matricule,
                            "Nom",nom,
                            "Prenom",prenom,
                             "Date embauche",dateEmbauche,
                             "Contrat",(contrat==null?0:contrat.getNumeroContrat().intValue()),
                             "Contact",(contact==null?"":contact.getTelephonePersonnel())
                             );
    }



    // Un exemple d'une requete native SQL realise
    //  sur les tables
    //

    // Retourne les employes dont la chaine de recherche
    //  est dans le nom
    //
    static public List<Employe> finder(Session session,String likeNom)
    {
        // Pour assurrer la maj de la base avant de faire une 
        //  interrogation de la base de données sans passer
        //  par les objets persistants
        session.flush();
        
        // Requete de recherche du nom d'un employe
        List result = session.createCriteria(Employe.class)
            .add(Restrictions.like("nom","%"+likeNom+"%"))
            .list();
        return (List<Employe>)(result);
    }
    
}
        