package fr.cnam.test;

import org.hibernate.*;
import org.hibernate.cfg.*;
import org.hibernate.transform.*;
import org.hibernate.criterion.*;

import javax.persistence.*;
import java.io.*;
import java.util.*;

// Classe de definition d'un projet
//
@Entity
@Table(name="Projet")
public class Projet implements Serializable
{
    // Clef d'un projet
    @Id
    @GeneratedValue
    private Integer idProjet;

    // Code projet
    @Column
    private String code;

    // Nom du projet
    @Column
    private String nom;

    // Les employes qui participent au projet
    //
    @ManyToMany(cascade=CascadeType.ALL, fetch=FetchType.EAGER)
    @JoinTable(name="Participation")
    @JoinColumn(name="idProjet")
    private Set<Employe> employes;

    // Constructeur par defaut utilise par la persistence
    //
    public Projet()
    {
        code=nom="";
        employes=new HashSet<Employe>();
    }

    // Constructeur applicatif
    //
    public Projet(String code,String nom)
    {
        this.code=code;
        this.nom=nom;
        employes=new HashSet<Employe>();
    }

    // Methode qui ajoute un employe au projet
    //
    public void ajouterEmploye(Employe employe)
    {
            employes.add(employe);
    }

    // Defnition du critere d'unicite de la collection Set
    //
    public boolean equals(Object p)
    {
        return ((Projet)p).code.equals(code);
    }
    public int hashCode()  // Indispensable pour equals
    {
        return code.hashCode();
    }

    public String getCode(){return code;}
    public String getNom(){return nom;}
    public void setCode(String c){code=c;}
    public void setNom(String n){nom=n;}

    public void supprimerEmploye(Integer matricule)
    {
        for(Employe e:employes)
            if (e.getMatricule().intValue()==matricule.intValue())
                employes.remove(e);
    }
    
    // Chaine d'un projet
    //
    public String toString()
    {
        String se="Les membres du projet:\n";
        for(Employe e:employes)se=se+e.getNom()+" "+e.getPrenom()+"\n";
        return String.format("%15s : %-20s\n%15s : %-20s\n%s",
                             "Code",code,
                             "Nom",nom,
                             se);
        
    }

    // Affichage d'un projete
    //
    public void aff()
    {
        System.out.println("=============================");
        System.out.println(this);
        System.out.println("=============================");
    }


}
                      