package fr.cnam.test;

import org.hibernate.*;
import org.hibernate.cfg.*;
import org.hibernate.transform.*;
import org.hibernate.criterion.*;

import javax.persistence.*;
import java.io.*;
import java.util.*;

// Classe de definition d'un sous-traitant qui herite
//  de Employe
//
//@Entity
//@Table(name="SousTraitant")
@Entity
public class SousTraitant extends Employe implements Serializable
{
    @Column
        private String societe;

    public SousTraitant(){}

    public SousTraitant(int matricule,
                      String nom,
                      String prenom,
                      String dateEmbauche,
                      Contrat contrat,
                      Contact contact,
                      String societe)
    {
        super(matricule,nom,prenom,dateEmbauche,contrat,contact);
        this.societe = societe;
    }

    // Chaine d'un commercial
    //
    public String toString()
    {
        return String.format("%s\n%15s : %-30s",
                             super.toString(),
                             "Societe",societe);
    }

}
