// Programme qui montre une injection de dependance par un fichier de configuration xml avec une gestion de bean suivant les principes de J2EE
// 
//
import java.sql.*;
import java.util.*;

import fr.cnam.myjee.*;
import fr.cnam.test.*;

public class Exemple09
{ 
    public static void main(String[] args) throws Exception
    {
        // Liaison directe

        PersonneLister2 plist = new PersonneLister2();
        List<Personne> lp = plist.chercherParNom(null);
        for(Personne p:lp) System.out.println(p.toString());

        System.out.println("====================================================");


        // Utilisation d'un fichier de configuration 
        // 
        ApplicationContext ctx = new
            FileSystemXmlApplicationContext("../config.xml");
        
        PersonneLister lister = (PersonneLister)ctx.getBean("PersonneLister");
        
        lp = lister.chercherParNom(null);
        for(Personne p:lp)
            System.out.println(p.toString());

        System.out.println("Recherche de LAF :");
        System.out.println("------------------");
        lp = lister.chercherParNom("LAF");
        for(Personne p:lp)
            System.out.println(p.toString());

        System.out.println("====================================================");

        // Utilisation d'un deuxieme fichier de configuration
        ctx = new
            FileSystemXmlApplicationContext("../config2.xml");
        
        lister = (PersonneLister)ctx.getBean("PersonneLister");
        
        lp = lister.chercherParNom(null);
        for(Personne p:lp)
            System.out.println(p.toString());

        System.out.println("Recherche de AAA :");
        System.out.println("------------------");
        lp = lister.chercherParNom("AAA");
        for(Personne p:lp)
            System.out.println(p.toString());
    }
}