package fr.cnam.myjee;

import java.util.*;
import java.lang.reflect.*;

public class BeanConf
{
    protected String id;
    protected String nomClasse;
    protected Class<?> classe;
    protected ArrayList<Attribut> attributsValue;
    protected ArrayList<Attribut> attributsRefLocal;

    public BeanConf(String id,String nomClasse) throws Exception
    {
        this.id = id;
        this.nomClasse = nomClasse;
        attributsValue = new ArrayList<Attribut>();
        attributsRefLocal = new ArrayList<Attribut>();
        classe = Class.forName(nomClasse,true, 
                               ClassLoader.getSystemClassLoader());
    }

    // Invocation du setteur qui realise l'injection de dependance
    //
    public void invokeSetteurRefLocal(ApplicationContext ctx,
                                      Bean bean,
                                      String nomAtribut,
                                      Class<?> classeParam,
                                      Object valeur) throws Exception
    {
        String idBean = (String)valeur;
        String nomMethode = "set"+nomAtribut.substring(0,1).toUpperCase()+
            nomAtribut.substring(1,nomAtribut.length());
        
        Method setteur = classe.getMethod(nomMethode,classeParam);
        setteur.invoke(bean,ctx.getBean(idBean));
    }

    // Ajout d'une propriete au bean vue comme un attribut du bean
    //
    public void addPropertyValue(ApplicationContext ctx,
                                 String nomAttribut,
                                 Class<?> classe,
                                 Object valeur)
    {
        attributsValue.add(new Attribut(nomAttribut,classe,valeur));
    }

    // Ajout d'une propriete de reference au bean
    //
    public void addPropertyRefLocal(ApplicationContext ctx,
                                    String nomAttribut,
                                    Class<?> classe,
                                    Object valeur)
    {
        attributsRefLocal.add(new Attribut(nomAttribut,classe,valeur));
    }

}

