package fr.cnam.myjee;

import java.util.*;
import java.lang.reflect.*;
import java.io.*;
import org.jdom2.*;
import org.jdom2.input.*;
import org.jdom2.filter.*;

public class FileSystemXmlApplicationContext implements ApplicationContext
{
    private Hashtable<String,BeanConf> hashBeansConf;
    
    public FileSystemXmlApplicationContext(String fichierConf) throws Exception
    {
        hashBeansConf = new Hashtable<String,BeanConf>();

        // -----------------------------------------------------
        // interpretation du fichier de configuration XML
        //  initialisation des beans de configuration
        // -----------------------------------------------------
        
        org.jdom2.Document document;
        Element racine;

        SAXBuilder sxb = new SAXBuilder();
        document = sxb.build(new File(fichierConf));
        racine = document.getRootElement();

        //
        List listBeans = racine.getChildren("bean");
        Iterator i = listBeans.iterator();
        while(i.hasNext())
            {
                Element courant = (Element)i.next();
                String idBean = courant.getAttributeValue("id");
                String nomClasseBean = courant.getAttributeValue("class");

                BeanConf beanConf = new BeanConf(idBean,
                                                 nomClasseBean);
                hashBeansConf.put(idBean,beanConf);
            }

        racine = document.getRootElement();
        listBeans = racine.getChildren("bean");
        i = listBeans.iterator();
        while(i.hasNext())
            {
                Element courant = (Element)i.next();
                String idBean = courant.getAttributeValue("id");
                List propertyList = courant.getChildren("property");
                Iterator j = propertyList.iterator();
                while(j.hasNext())
                    {
                        Element property = (Element)j.next();
                        String nomProperty = property.getAttributeValue("name");
                        Element ref = property.getChild("ref");
                        if (ref!=null)
                            {
                                BeanConf bc = hashBeansConf.get(idBean);
                                Class<?> c = Class.forName(ref.getAttributeValue("class"),true, 
                                                           ClassLoader.getSystemClassLoader());
                                bc.addPropertyRefLocal(this,nomProperty,c,ref.getAttributeValue("local"));
                            }

                        Element val = property.getChild("value");
                        if (val!=null)
                            {
                                BeanConf bc = hashBeansConf.get(idBean);
                                bc.addPropertyValue(this,nomProperty,String.class,val.getText());
                            }
                    }
            }
    }
    
    // Creation d'un bean defini dans la configuration
    //
    public Bean getBean(String idBean) throws Exception
    {

        BeanConf beanConf = hashBeansConf.get(idBean);

        Class<?> classBean = Class.forName(beanConf.nomClasse,true, 
                                           ClassLoader.getSystemClassLoader());

        // Instanciation du bean
        //
        Class<?>[] classes = new Class<?>[beanConf.attributsValue.size()];
        int i=0;
        for(Attribut a : beanConf.attributsValue)
            classes[i++]=a.classe;
        Constructor constr = classBean.getConstructor(classes);
            
        Object[] params = new Object[beanConf.attributsValue.size()];
        i=0;
        for(Attribut a : beanConf.attributsValue) params[i++]=a.valeur;
        Bean bean = (Bean) constr.newInstance(params);

        // REALISER L'INJECTION DE DEPENDANCE
        //
        for(Attribut a : beanConf.attributsRefLocal) 
            beanConf.invokeSetteurRefLocal(this,bean,
                                           a.nom,a.classe,a.valeur);

        return bean;
    }
}