package fr.cnam.ejb;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;


import fr.cnam.data.InfoMessage;
import fr.cnam.ejb.*;

/**
 * Message-Driven Bean implementation class for: Messages
 * 
 * Le rle de ce Driven Message est de stocker en BD le message reu dans le Topic
 * 
 */
@MessageDriven(
		activationConfig = { @ActivationConfigProperty(
				propertyName = "destination", propertyValue = "java:jboss/exported/jms/topic/duke-topic"), @ActivationConfigProperty(
				propertyName = "destinationType", propertyValue = "javax.jms.Topic")
		}, 
		mappedName = "java:jboss/exported/jms/topic/duke-topic")
public class Messages implements MessageListener {
	
   // @EJB
	//private GestionCompteClientRemote compte;
    
    /**
     * Default constructor. 
     */
    public Messages() {
        // TODO Auto-generated constructor stub
    }
	
	/**
     * @see MessageListener#onMessage(Message)
     */
    public void onMessage(Message message) {
        // TODO Auto-generated method stub
    	
        String mess="*******";
        TextMessage textMessage =(TextMessage)message;
        try{
        	mess = textMessage.getText();
        	}catch(Exception ex) {}
        System.out.println("MESSAGE : "+mess);
        
        InfoMessage info = new InfoMessage(mess);
        info.sauver();
    	
       // compte.setMessage(mess);
    }
    
    

}
