package fr.cnam.ejb;

import javax.ejb.LocalBean;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Any;
import javax.ejb.*;

import java.io.Serializable;
import java.util.*;

import fr.cnam.data.*;

/**
 * Session Bean implementation class GestionCompteClient
 * 
 * EJB Stateful de gestion du compte d'un client
 *  Quand un utilisateur d'identifie au SI, ce sateful gre en session
 *    le CompteClient de l'utilisateur qui contient ses lments d'identification et 
 *    l'historique de toutes les commandes ralises par le client
 */

@Stateful
@LocalBean
@SessionScoped
public class GestionCompteClient implements GestionCompteClientRemote, GestionCompteClientLocal,Serializable {
	
	private CompteClient compte;  // Le compte client d'un utilisateur
	
	private String message;

    /**
     * Default constructor. 
     */
    public GestionCompteClient() {
        // TODO Auto-generated constructor stub
    	System.out.println("CREATION DU EJB STATEFUL : GestionCompteClient");
    	message="N/A";
    }
    
    public CompteClient creerNouveauCompte(String nom)
    {
    	return CompteClient.getInstance(nom);
    }
    
    public void connexion(String identifiant) {
    	compte = CompteClient.getCompte(identifiant);
    }
    
    public ArrayList<CompteClient> getAllComptes() {
    	return CompteClient.getAll();
    }
    
    public boolean siCompteExiste(String nom) {
    	ArrayList<CompteClient> liste = getAllComptes();
		boolean existe=false;
		if (liste!=null)
			for(CompteClient c:liste){if (c.getNom().equals(nom))existe=true;}
		return existe;
    }
    
    public Commande creerCommande() {
    	return compte.creerCommande();
    }

	public CompteClient getCompte() {
		return compte;
	}

	public void setCompte(CompteClient compte) {
		this.compte = compte;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	
	

}
