package fr.cnam.ejb;

import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import javax.persistence.EntityManager;
import fr.cnam.data.*;

import java.util.*;

/**
 * Session Bean implementation class GestionStock
 * 
 * EJB Singleton
 *   Gestion du stock de livre qui permet de synhroniser la rservation d'un livre
 */
@Singleton
@LocalBean
public class GestionStock implements GestionStockRemote {

    /**
     * Default constructor. 
     */
    public GestionStock() {
        // TODO Auto-generated constructor stub
    	System.out.println("===== CREATION DU SINGLETON : GestionStock");
    	
    }
    
    // Permet d'initaliser le stock des livres de la BD
    //
    public void initialiserStockLivres() {
    	Livre.initialiserStock();
    }
    
    // Mthode permettant de rserver un article
    //   On vrifie si l'article  rserver est disponible
    // Cette mthode est SYNCHRONE afin que deux utilisateurs ne puissent pas
    //  rserver le mme livre en mme temps
    //
   synchronized   public boolean reserverArticle(GestionCompteClientRemote compte,Panier panier) {
    	boolean valide=false;  // Vrai si tous les articles sont disponibles
    	
		
    	// On calcule le nombre de livre en stock pour chaque article
    	//
    	Enumeration<String> references = panier.getArticles().keys();
    	while(references.hasMoreElements()) {
    		String reference = references.nextElement(); 		
    		Article article = panier.getArticles().get(reference);
    		try {
    			EntityManager em=SiteDAO.getEM();
    			ArrayList<Livre> l = (ArrayList<Livre>)(em.createQuery("SELECT livres FROM Livre livres WHERE reference='"+article.getReference()+"' AND reserve is false").getResultList());
    			if (l!=null) 
    					{
    						article.setNbEnStock(l.size());
    						for(Livre e:l) {
    							article.addLivreNonReserve(e);
    						}
    					}
    			else article.setNbEnStock(0);
    			em.close();
    			}catch(Exception ex) {}
    	}
    	
    	//    	Pour tester la synchronisation
    		if (compte.getCompte().getNom().contentEquals("TORTUE")) {
    			System.out.println("===> ATTENTE DE 10 secondes");
    			try {Thread.sleep(10000);}catch(Exception ex) {ex.printStackTrace();}
    		}
        	
    	// Si le panier est valide (tous les articles commands sont en stock), on rserve chaque livre commands
    	//  
    	if (panier.isValide()) {
    		valide=true;
    		Enumeration<String> references2 = panier.getArticles().keys();
    		Commande com = compte.creerCommande();
    		while(references2.hasMoreElements()) {
    			String reference = references2.nextElement();
    			Article article = panier.getArticles().get(reference);
    			try {
    				EntityManager em=SiteDAO.getEM();
    				ArrayList<Livre> l = article.getLivresNonReserves();
    				if (l!=null) {
    					for(int k=0;k<article.getNbAchetes();k++) {
    						// Rservation du livre en BD
    						l.get(k).setReserve(true);
    		    			l.get(k).update();
    		    			// On met  jour la commande
    		    			com.ajouterLivre(l.get(k).getReference());
    					}

    				}
    				em.close();
    			}catch(Exception ex) {ex.printStackTrace();}
    		}
    		
    		// On sauve le compte du client en BD
			compte.getCompte().update();
			panier.clear();
    	}
    	return valide;
    }

}
