package fr.cnam.ejb;

import java.io.Serializable;

import javax.ejb.*;
import javax.enterprise.context.SessionScoped;

import fr.cnam.data.*;

/**
 * Session Bean implementation class Panier
 * 
 * EJB Stateful
 *    Panier de la commande courante d'un utilisateur dans lequel l'utilisateur
 *      ajoute les livres au fur et  mesure de sa navigation.
 *     
 */
@Stateful
@LocalBean
public class PanierImpl implements PanierImplRemote {

	private Panier panier;
		
    /**
     * Default constructor. 
     */
    public PanierImpl() {panier = new Panier();}
    
    public void addArticle(String reference) {
    	panier.addArticle(reference);
    }
    
    public void supprimerArticle(String reference) {
    	panier.supprimerArticle(reference);
    }
    
    public boolean valider(GestionCompteClientRemote compte,GestionStockRemote stock) {
    	return stock.reserverArticle(compte,panier);
    }
    
    public void annuler(GestionCompteClientRemote compte,GestionStockRemote stock) {
    	panier.clear();
    }

	public Panier getPanier() {
		return panier;
	}
	
}
