package fr.cnam.ejb;

import javax.ejb.LocalBean;
import javax.ejb.Stateless;

import fr.cnam.data.InfoMessage;

/**
 * Session Bean implementation class Message
 * 
 * EJB Stateless
 *   Mise  jour et accs au message stock en BD.
 *   Ce message est mis  jour par le Driven Message sur notification.
 *   
 */
@Stateless
@LocalBean
public class ZoneMessage implements ZoneMessageRemote {
	
    /**
     * Default constructor. 
     */
    public ZoneMessage() {
        // TODO Auto-generated constructor stub
    	System.out.println("Constructeur de ZoneMessage");
    }

	public String getMessage() {
		InfoMessage info = new InfoMessage();
		info.charger();
		return info.getMessage();
	}

	public void setMessage(String message) {
		System.out.println("setMessage> "+message);
		InfoMessage info = new InfoMessage(message);
		info.sauver();
	}

}
