package fr.cnam.data;

import java.io.Serializable;
import java.util.*;

import javax.persistence.*;

/**
 * Entity implementation class for Entity: Commande
 * 
 * Une commande d'un utilisateur qui est stock en base de donnes.
 *
 */
@Entity

public class Commande implements Serializable {

	
	private static final long serialVersionUID = 1L;
	
	@Id
	@GeneratedValue
	private Integer id;
	
	@Column
	private Integer numero;
	
	@OneToMany(cascade=CascadeType.ALL, fetch=FetchType.EAGER,orphanRemoval = true)
	@JoinColumn(name="idCommande")
	private Set<LivreCommande> livres;

	public Commande() {
		super();
	}
	
	public Commande(Integer numero) {
		super();
		this.numero=numero;
		livres = new HashSet<LivreCommande>();
	}
	
	public void ajouterLivre(String reference) {
		LivreCommande lcom = new LivreCommande(reference);
		livres.add(lcom);
	}
		
	public String toString() {
		return String.format("commande id=%3d numero=%3d", id,numero);
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public Set<LivreCommande> getLivres() {
		return livres;
	}

	public void setLivres(Set<LivreCommande> livres) {
		this.livres = livres;
	}
   
	public boolean equals(Commande c) {return this.numero.equals(c.getNumero());}
	public int hashCode(){return numero;}


	public Integer getNumero() {
		return numero;
	}

	public void setNumero(Integer numero) {
		this.numero = numero;
	}
}
