package fr.cnam.data;

import java.io.Serializable;
import java.util.*;

import javax.persistence.*;

/**
 * Entity implementation class for Entity: CompteClient
 * 
 * Chaque compte client est stock en base de donnes.
 *
 */
@Entity
public class CompteClient implements Serializable {

	
	private static final long serialVersionUID = 1L;
	
	@Id
	@GeneratedValue
	private Integer id;
	
	@Column
	private String nom;   // Identifiant du client
	
	@OneToMany(cascade=CascadeType.ALL, fetch=FetchType.EAGER,orphanRemoval = true)
	@JoinColumn(name="idCompteClient")
	private Set<Commande> commandes;  // Les commandes ralises par le client
	
	private static int numc=0; // Pour numroter les commandes

	// Constructeur par dfaut
	//
	public CompteClient() {
		super();
	}
	
	// Constructeur du compte client avec le nom du client
	//
	public CompteClient(String nom) {
		super();
		this.nom=nom;
		this.commandes=new HashSet<Commande>();
	}
	
	// Retourne et cre en BD une nouvelle instance d'un compte client
	//  (le id est cr)
	//
	public static CompteClient getInstance(String nom) {
		CompteClient compte = new CompteClient(nom);
		compte.create();
		return compte;
	}

	// Cration en BD
	//
	public void create() {
		EntityManager em=SiteDAO.getEM();
		em.getTransaction().begin();
		em.persist(this);
		em.getTransaction().commit();
		em.close();
	}
	
	// Mise  jour en BD
	//
	public void update() {
		EntityManager em=SiteDAO.getEM();
		CompteClient l = em.find(this.getClass(), id);
		if (l==null) {
		em.getTransaction().begin();
		em.persist(this);
		em.getTransaction().commit();
		}
		else {
			em.getTransaction().begin();
			CompteClient cc = em.merge(this);
			this.setCommandes(cc.getCommandes());  // <=== IMPORTANT
			em.getTransaction().commit();
		}
		em.close();
	}
	
	public static ArrayList<CompteClient> getAll() {
		ArrayList<CompteClient> l=null;
		try {
		EntityManager em=SiteDAO.getEM();
		l = (ArrayList<CompteClient>)(em.createQuery("SELECT comptes FROM CompteClient comptes").getResultList());
		em.close();
		}catch(Exception ex) {return null;}
		return (ArrayList<CompteClient>)l;
	}
	
	public static CompteClient getCompte(String identifiant) {
		CompteClient c=null;
		try {
		EntityManager em=SiteDAO.getEM();
		ArrayList<CompteClient> l = (ArrayList<CompteClient>)(em.createQuery("SELECT comptes FROM CompteClient comptes WHERE nom='"+identifiant+"'").getResultList());
		if ( (l!=null) ) c=l.get(0);
		em.close();
		}catch(Exception ex) {return null;}
		return c;
	}
	
	public void ajouterLivre(Commande com,String reference) {
		com.ajouterLivre(reference);
	}
	
	public Commande creerCommande() {
		Commande com = new Commande(numc++);
		commandes.add(com);
		return com;
	}
	
	public String toString() {
		return String.format("%3d %s", id,nom);
	}
	
	public boolean equals(CompteClient c) {return c.equals(nom);}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}
	
	public Set<Commande> getCommandes(){
		return commandes;
	}

	public void setCommandes(Set<Commande> commandes) {
		this.commandes = commandes;
	}

	public String getNom() {
		return nom;
	}

	public void setNom(String nom) {
		this.nom = nom;
	}
   
}
