package fr.cnam.data;

import java.io.Serializable;
import javax.persistence.*;

/**
 * Entity implementation class for Entity: InfoMessage
 *
 *  Chaque message notifi est stock en base de donnes.
 */
@Entity
public class InfoMessage implements Serializable {

	
	private static final long serialVersionUID = 1L;
	
	@Id
	private Integer id;
	
	@Column
	private String message;

	public InfoMessage() {
		super();
		this.id=0;
	}
	
	public InfoMessage(String message) {
		super();
		this.id=0;
		this.message=message;
	}
	
	public void sauver() {
		EntityManager em=SiteDAO.getEM();
		InfoMessage l = em.find(this.getClass(), id);
		if (l==null) {
			em.getTransaction().begin();
			em.persist(this);
			em.getTransaction().commit();
		}
		else {
			em.getTransaction().begin();
			em.merge(this);
			em.getTransaction().commit();
		}
		em.close();
	}
	
	public void charger() {
		EntityManager em=SiteDAO.getEM();
		InfoMessage l =  em.find(this.getClass(), id);
		if (l!=null)
			this.setMessage(l.getMessage());
		else
			this.setMessage(null);
	}


	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	
	
   
}
