package fr.cnam.data;

import java.io.Serializable;
import java.util.*;
import javax.persistence.*;

/**
 * Entity implementation class for Entity: Livre
 *
 * Un livre est stock en base de donnes.
 */
@Entity

public class Livre implements Serializable {

	
	private static final long serialVersionUID = 1L;
	
	@Id
	@GeneratedValue
	private Integer id;
	
	@Column
	private String reference;
	
	@Column
	private String titre;
	
	@Column
	private Boolean reserve;

	public Livre() {
		super();
	}
	public Livre(String reference,String titre) {
		this.reference=reference;
		this.titre=titre;
		this.reserve=false;
	}
	
	public void update() {
		EntityManager em=SiteDAO.getEM();
		Livre l = em.find(this.getClass(), id);
		if (l==null) {
			em.getTransaction().begin();
			em.persist(this);
			em.getTransaction().commit();
		}
		else {
			em.getTransaction().begin();
			em.merge(this);
			em.getTransaction().commit();
		}
		em.close();
	}
	
	
	public static void initialiserStock()
	{
		ArrayList<Livre> livres = new ArrayList<Livre>();
		livres.add(new Livre("LIVRE-SF-001","Les cavernes d'acier;Isaac Asimov"));
		livres.add(new Livre("LIVRE-SF-001","Les cavernes d'acier;Isaac Asimov"));
		livres.add(new Livre("LIVRE-SF-001","Les cavernes d'acier;Isaac Asimov"));
		livres.add(new Livre("LIVRE-SF-002","Dune;Frank Herbert"));
		livres.add(new Livre("LIVRE-POLICIER-001","Mort sur le nil;Agatha Christie"));
		livres.add(new Livre("LIVRE-POLICIER-001","Mort sur le nil;Agatha Christie"));
		EntityManager em=SiteDAO.getEM();
		em.getTransaction().begin();
		for(Livre l:livres) em.persist(l);
		em.getTransaction().commit();
		em.close();
	}
	
	public String toString() {
		return String.format("%3d %8s %30s %10s", id,reference,titre,reserve?"reserv":"non reserv");
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getReference() {
		return reference;
	}

	public void setReference(String reference) {
		this.reference = reference;
	}

	public String getTitre() {
		return titre;
	}

	public void setTitre(String titre) {
		this.titre = titre;
	}
	public Boolean getReserve() {
		return reserve;
	}
	public void setReserve(Boolean reserve) {
		this.reserve = reserve;
	}
   
}
