package fr.cnam.data;

import java.io.Serializable;
import javax.persistence.*;

/**
 * Entity implementation class for Entity: LivreCommande
 *
 * Un livre command, lment de la commande d'un client qui est stock en base de donnes.
 */
@Entity

public class LivreCommande implements Serializable {

	@Id
	@GeneratedValue
	private Integer id;
	
	@Column
	private String reference;
	
	private int num;
	private static int numc=0;
	
	private static final long serialVersionUID = 1L;

	public LivreCommande() {
		super();
	}
	
	public LivreCommande(String reference) {
		this.num=numc++;
		this.reference=reference;
	}
	
	public boolean equals(LivreCommande c) {return this.num==c.getNum();}
	public int hashCode(){return num;}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public int getNum() {
		return num;
	}

	public void setNum(int num) {
		this.num = num;
	}

	public String getReference() {
		return reference;
	}

	public void setReference(String reference) {
		this.reference = reference;
	}
}
