package fr.cnam.data;
import java.util.*;

// Classe de dfinition d'un panier qui est constitu d'articles.
//  Le panier n'est pas stock en base de donnes mais gr dans un Stateful
//
public class Panier {
	
	private Hashtable<String,Article> articles;
	
	public Panier() {articles=new Hashtable<String,Article>();}
	
	public void addArticle(String reference) {
		Article aa = articles.get(reference);
		if (aa==null) {
			articles.put(reference,new Article(reference,1,-1));
		}
		else {
			aa.setNbAchetes(aa.getNbAchetes()+1);
		}
	}
	
	public void supprimerArticle(String reference) {
		Article article = articles.get(reference);
		if (article.getNbAchetes()==1) articles.remove(reference);
		else article.setNbAchetes(article.getNbAchetes()-1);
	}
	
	public boolean isValide() {
		boolean valide=true;
		if (getArticles().size()==0) return false;
		Enumeration<String> references = getArticles().keys();
    	while(references.hasMoreElements()) {
    		String reference = references.nextElement();
    		Article article = getArticles().get(reference);
    		if (article.getNbAchetes()>article.getNbEnStock())valide=false;
    	}
    	return valide;
	}
	
	public Hashtable<String,Article> getArticles() {
		return articles;
	}

	public void clear() {articles.clear();}

	
	
}
