<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="ISO-8859-1">
<title>Utilisateur</title>
</head>
<body>
<jsp:useBean id="gestionlivre" scope="session" class="fr.cnam.ejb.GestionLivre"/>
<jsp:useBean id="panier" scope="session" class="fr.cnam.ejb.PanierImpl"/>
<jsp:useBean id="compte" scope="session" class="fr.cnam.ejb.GestionCompteClient"/>
<jsp:useBean id="stock" scope="application" class="fr.cnam.ejb.GestionStock"/>
<%@ page import = "java.util.*" %>
<%@ page import = "fr.cnam.data.*" %>
<%@ page import = "fr.cnam.ejb.*" %>

<h2>Se connecter</h2>

<%
	// ===   Traitement formulaire de connection
	if (request.getParameter("SeConnecter") != null) 
	{
		String identifiant = request.getParameter("nom");
		if (identifiant.equals(""))
			session.setAttribute("erreur", "VOUS DEVEZ SAISIR UN IDENTIFIANT");
		else if (! compte.siCompteExiste(identifiant))
			session.setAttribute("erreur", "LE COMPTE N'EXISTE PAS");
		else compte.connexion(identifiant);
		response.sendRedirect("Utilisateur.jsp");
		return;
	}
	if (request.getParameter("SeDeconnecter") != null) 
	{
		compte.setCompte(null);
		response.sendRedirect("Utilisateur.jsp");
		return;
	}
    // ==================================================================
    		
	String erreur = (String) session.getAttribute("erreur");
	if (erreur!=null)
	{
		out.println("<font style='color:red;' > "+erreur+"</font> <br>");
		session.removeAttribute("erreur");
	}
	String identifiant ="";
	if (compte.getCompte() == null) out.println("VOUS N'ETES PAS CONNECTE<br>");
	 else {
		 identifiant = compte.getCompte().getNom();
		 out.println("VOUS ETES CONNECTE(E). BIENVENUE " + identifiant + "<br>");
	 }
	
%>
<form action="" method="POST">
<input type=text name=nom value="${identifiant}"><br>
<input type=submit name=SeConnecter value="Se connecter">
<input type=submit name=SeDeconnecter value="Se dconnecter">
</form>
<br><br>
<h2>Passer une commande</h2>

<%
	ArrayList<Livre> livres = gestionlivre.getAllLivres();
if (livres==null) out.println("PAS DE LIVRES<br>");
else if (compte.getCompte()!=null)
{
		int i = 0;
		for (Livre l : livres) {
			String reference = l.getReference();
			out.println("<form action=AjouterArticle?action=ajouter&reference=" + reference + " method=POST>");
			String ligne = String.format("%15s %30s", l.getReference(), l.getTitre());
			out.println(ligne + "<input type=submit name=AjouterArticle" + i + " value=Acheter><br>");
			out.println("</form>");
			i++;
		}
	}
%>

<%
	// On appelle l'EJB Stateful PanierImpl pour consulter le panier
	//  et l'afficher sous le formulaire
	// ==============================================================
	
%>
<h2> Contenu du panier </h2>
<%
Enumeration<String> references = panier.getPanier().getArticles().keys();
while(references.hasMoreElements()) 
{
	String reference = references.nextElement();
	Article article = panier.getPanier().getArticles().get(reference);
	int nb = article.getNbAchetes();
	if (article.getNbEnStock()==-1) 
		for(int k=0;k<article.getNbAchetes();k++) 
			out.println(article.getReference()+"<br>");
	else
		if (article.getNbAchetes()<=article.getNbEnStock())
			for(int k=0;k<article.getNbAchetes();k++) 
				out.println(article.getReference()+" DISPONIBLE<br>");
		else {
				for(int k=0;k<article.getNbEnStock();k++) 
					out.println(article.getReference()+" DISPONIBLE<br>");
				int i=0;
				for(int k=0;k<article.getNbAchetes()-article.getNbEnStock();k++) 
				{
					out.print(article.getReference()+" INDISPONIBLE ");
					out.print("<form action=AjouterArticle?action=supprimer&reference="+reference+"&identifiant="+identifiant+" method=POST>");
					out.print("<input type=submit name=SupprimerArticle"+i+" value=Supprimer><br>");
					out.println("</form>");
					i++;
				}
		}
}//while

%>
<h2> Valider le panier</h2>
<form action="ValiderPanier" method="POST">
<input type=submit name=Valider value=Valider>
<input type=submit name=Annuler value=Annuler>
</form>

<h2> Historique des commandes </h2>
<%
	if (compte.getCompte()!=null){
		for (Commande com : compte.getCompte().getCommandes()) {
			out.println("<u>Numero de la commande: " + com.getNumero() + "</u><br>");
			for (LivreCommande l : com.getLivres()) {
				out.println(String.format("%3d    %15s<br>", l.getId(), l.getReference()));
			}
			out.println("<br>");
		}
	}
%>



</body>
</html>