

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import fr.cnam.ejb.*;

/**
 * Servlet implementation class AjouterArticle
 * 
 * Action d'ajouter un article dans le panier qui est un EJB Stateful.
 * 
 */
@WebServlet("/AjouterArticle")
public class AjouterArticle extends HttpServlet {
	private static final long serialVersionUID = 1L;
       
    /**
     * @see HttpServlet#HttpServlet()
     */
    public AjouterArticle() {
        super();
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		response.getWriter().append("Served at: ").append(request.getContextPath());
		
		String action = (String)request.getParameter("action");
		String reference = (String)request.getParameter("reference");
		
		HttpSession session = request.getSession(true);
		PanierImplRemote panier = (PanierImplRemote)session.getAttribute("panier");
		
		if(action.equals("ajouter")) {
			panier.addArticle(reference);
		}
		
		if(action.equals("supprimer")) {
			panier.supprimerArticle(reference);
		}
		response.sendRedirect("Utilisateur.jsp");
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		doGet(request, response);
	}

}
