

import java.io.IOException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import fr.cnam.ejb.*;

/**
 * Servlet implementation class CreerCompteClient
 * 
 * Action d'initialiser le EJB Stateful du compte du client qui s'est connect au SI.
 * 
 */
@WebServlet("/CreerCompteClient")
public class CreerCompteClient extends HttpServlet {
	private static final long serialVersionUID = 1L;
       
    /**
     * @see HttpServlet#HttpServlet()
     */
    public CreerCompteClient() {
        super();
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		response.getWriter().append("Served at: ").append(request.getContextPath());
		
		String nom = request.getParameter("nom");
		try {
			HttpSession session = request.getSession(true);
			GestionCompteClientRemote compte = (GestionCompteClientRemote)session.getAttribute("compte");
			if (compte.siCompteExiste(nom))
				session.setAttribute("erreur", "compteexiste");
			else if (nom.equals("")) session.setAttribute("erreur", "comptevide");
			else compte.creerNouveauCompte(nom);
			response.sendRedirect("Administratif.jsp");
		}catch(Exception ex){response.getWriter().println("[CreerCompteClient.java (Servlet)] ERROR: "+ex);
			ex.printStackTrace(response.getWriter());
			;}
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		doGet(request, response);
	}

}
