

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Proxy;

import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.jms.*;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import fr.cnam.ejb.*;

/**
 * Servlet implementation class EnvoyerMessageServlet
 * 
 * Action qui envoie un message dans le Topic.
 * 
 */
@WebServlet("/EnvoyerMessageServlet")
@ApplicationScoped    // <<== IMPORTANT
public class EnvoyerMessageServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;

	
	@Resource(lookup = "java:jboss/exported/jms/queue/duke-queue",mappedName ="jms/duke-queue")
	private Queue onlineQueue;

	@Resource(lookup = "java:jboss/exported/jms/topic/duke-topic",mappedName ="jms/duke-topic")
	private Topic onlineTopic;

	@Inject
	@JMSConnectionFactory("java:jboss/DefaultJMSConnectionFactory")
	private JMSContext context;
	
	
	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public EnvoyerMessageServlet() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		response.getWriter().append("Served at: ").append(request.getContextPath());

		HttpSession session = request.getSession(true);

		String texte = (String)request.getParameter("texteAEnvoyer");

		JMSProducer messageProducer = context.createProducer();
		TextMessage message = context.createTextMessage();
		try{
			message.setText(texte);
			}catch(Exception ex){ex.printStackTrace();}
		messageProducer.send(onlineTopic,message);
		System.out.println("===== ENVOI DU MESSAGE DANS LE TOPIC");
		response.sendRedirect("Administratif.jsp");
		
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		doGet(request, response);
	}

}
