

import java.io.IOException;

import javax.jms.*;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;


import javax.annotation.*;
import javax.inject.*;
import javax.enterprise.context.ApplicationScoped;

import fr.cnam.ejb.*;

/**
 * Servlet implementation class TesterJMS
 * 
 * Actions sui permet de tester une file de message Queue  titre d'exemple.
 * 
 */
@WebServlet("/TesterJMS")
@ApplicationScoped    // <<== IMPORTANT
public class TesterJMS extends HttpServlet {
	private static final long serialVersionUID = 1L;


	
	@Resource(lookup = "java:jboss/exported/jms/queue/duke-queue",mappedName ="jms/duke-queue")
	private Queue onlineQueue;

	@Resource(lookup = "java:jboss/exported/jms/topic/duke-topic",mappedName ="jms/duke-topic")
	private Topic onlineTopic;

	@Inject
	@JMSConnectionFactory("java:jboss/DefaultJMSConnectionFactory")
	private JMSContext context;
	

	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public TesterJMS() {
		super();
		// TODO Auto-generated constructor stub

	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		response.getWriter().append("Served at: ").append(request.getContextPath());

		HttpSession session = request.getSession(true); 

		String texteSaisi = (String)request.getParameter("textesaisi");

		if (request.getParameter("EnvoyerMessageQueue")!=null) {
			try {
				
				JMSProducer messageProducer = context.createProducer();
				Message message = context.createMessage();
				try{message.setStringProperty("valeur", texteSaisi);}catch(Exception ex){ex.printStackTrace();}
				System.out.println( "It come from Servlet:"+ texteSaisi);
				messageProducer.send(onlineQueue,message);
				
			}catch(Exception ex) {ex.printStackTrace();}
		}
		if (request.getParameter("LireMessageQueue")!=null) {
			try {
				
				JMSConsumer messageConsumer = context.createConsumer(onlineQueue);
				Message message = (Message)messageConsumer.receive(1000);
				String texte="INCONNU";
				try{texte = message.getStringProperty("valeur");}catch(Exception ex){ex.printStackTrace();}
				System.out.println( "MESSAGE RECU: "+ texte);
				session.setAttribute("texte_message", texte);
				
			}catch(Exception ex) {System.out.println("Queue est vide");}
		}



		response.sendRedirect("Administratif.jsp");


	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		doGet(request, response);
	}


}
