

import java.io.IOException;
import java.util.ArrayList;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.annotation.Resource;
import javax.inject.Inject;
///import javax.jms.*;

import fr.cnam.ejb.*;

/**
 * Servlet implementation class ValiderPanier
 * 
 * Action qui valide le contenu du panier.
 * 
 */
@WebServlet("/ValiderPanier")
public class ValiderPanier extends HttpServlet {
	private static final long serialVersionUID = 1L;
	/*
	@Resource(lookup = "java:jboss/exported/jms/topic/duke-topic",mappedName ="jms/duke-topic")
	private Topic onlineTopic;

	@Inject
	@JMSConnectionFactory("java:jboss/DefaultJMSConnectionFactory")
	private JMSContext context;
       */
    /**
     * @see HttpServlet#HttpServlet()
     */
    public ValiderPanier() {
        super();
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		response.getWriter().append("Served at: ").append(request.getContextPath());
		
		
		// Utilisation de l'EJB PanierImpl pour valider le panier (EJB Statefull)
		//
		try {
			HttpSession session = request.getSession(true);
			PanierImplRemote panier = (PanierImplRemote)session.getAttribute("panier");
			GestionCompteClientRemote compte = (GestionCompteClientRemote)session.getAttribute("compte");
			GestionStockRemote stock = (GestionStockRemote)(getServletContext().getAttribute("stock"));
				
			if ((String)(request.getParameter("Valider"))!=null) {
				boolean valide = panier.valider(compte,stock);
				
				if (valide) {
					String texte = "COMMANDE de "+compte.getCompte().getNom();
					/*
					JMSProducer messageProducer = context.createProducer();
					TextMessage message = context.createTextMessage();
					try{
						message.setText(texte);
						}catch(Exception ex){ex.printStackTrace();}
					messageProducer.send(onlineTopic,message);
					System.out.println("===== ENVOI DU MESSAGE DANS LE TOPIC");
					*/
				}
				
			}
			if ((String)(request.getParameter("Annuler"))!=null) {
				panier.annuler(compte,stock);
			}
			
			// On recharge la page
			response.sendRedirect("Utilisateur.jsp");
			
		}catch(Exception ex){response.getWriter().println("[AjouterArticle.java (Servlet)] ERROR: "+ex);
			ex.printStackTrace(response.getWriter());
			;}

	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		doGet(request, response);
	}

}
