// FactoryDevise.java
// Le factory de devise est un OD qui permet de crer a distance
//   une nouvelle devise qui est aussi un OD
// Il permet aussi d'obtenir le stub de n'importe quelle devise.
//

import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.*;

/* Les packages de RMI */
import java.rmi.*;
import java.rmi.server.*;

public class FactoryDevise extends UnicastRemoteObject implements FactoryDeviseInt
{
    // Stockage des OD qui sont des devises indexes par les noms de change
    //   
    private Hashtable<String,Devise> devises;
    
    // Constructeur
    public FactoryDevise() throws RemoteException
    {
        super(9101);
        devises = new Hashtable<String,Devise>();
    }
    
    // Creation distante d'une devise
    public void creerDevise(String nom1, String nom2,double taux) throws RemoteException
    {
        System.out.println("Creation d'une devise: "+nom1+" "+nom2);
        Devise devise = new Devise(nom1,nom2,taux);
        devises.put(nom1+"_"+nom2,devise);
    }

    // Retourne le stub d'une devise pour le client
    public DeviseInt getDevise(String nom1, String nom2) throws RemoteException
    {
        try{
            Devise devise = devises.get(nom1+"_"+nom2);
            Remote stub = UnicastRemoteObject.toStub((Remote)devise);
            return((DeviseInt)stub);
        }catch(NoSuchObjectException ex){return null;}
    }
}

