// Client.java
// Le client utilise le factory distant pour :
//   - creer deux nouvelles devises par defaut
//   - permet de crer une nouvelle devise et la tester
//

import java.awt.*;
import java.io.*;
import java.net.*;

/* Les packages de RMI */
import java.rmi.*;
import java.rmi.server.*;

public class Client
{
    public static void main(String args[]) throws RemoteException,IOException,NotBoundException
    {
        // Adresse Ip ou nom de domaine du serveur
        String hostServeur="localhost";
        if (args.length==1)
            hostServeur=args[0];
        
        // Connexion au factory de devise
        FactoryDeviseInt fact = (FactoryDeviseInt)Naming.lookup("rmi://"+hostServeur+":9100/DEVISES");
    
        // Cration  distance de deux devises par dfaut
        fact.creerDevise("FRANCS","EURO",1.0/6.56);
        fact.creerDevise("FRANCS","DOLLARS",0.98);

        // Programme de test de creation de devise et
        //  d'utilisation des devises
        //
        while (true)
            {
                double val,resultat;
                DataInputStream in = new DataInputStream(System.in);

                System.out.println("Creer un devise (o,n) ?");
                String rep = in.readLine();
                if (rep.equals("o"))
                    {
                        System.out.print("Nom1 : ");
                        String nomd1 = in.readLine();
                        System.out.print("Nom2 : ");
                        String nomd2 = in.readLine();
                        System.out.print("Taux : ");
                        double taux = Double.parseDouble(in.readLine());
                    
                        fact.creerDevise(nomd1,nomd2,taux);
                    }
            
                System.out.println("Conversion de ");
                String nom1 = in.readLine();
                System.out.println("vers ");
                String nom2 = in.readLine();

                DeviseInt devise = fact.getDevise(nom1,nom2);
            
                System.out.print(nom1+" : ");
                System.out.flush();
                val = Double.parseDouble(in.readLine());
                resultat = devise.convertir1(val);
                System.out.println(nom2+" : "+resultat);
            }
    }
}
